// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.resourcemanager.apimanagement.fluent.models.TenantConfigurationSyncStateContractInner;
import java.time.OffsetDateTime;

/**
 * An immutable client-side representation of TenantConfigurationSyncStateContract.
 */
public interface TenantConfigurationSyncStateContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the branch property: The name of Git branch.
     * 
     * @return the branch value.
     */
    String branch();

    /**
     * Gets the commitId property: The latest commit Id.
     * 
     * @return the commitId value.
     */
    String commitId();

    /**
     * Gets the isExport property: value indicating if last sync was save (true) or deploy (false) operation.
     * 
     * @return the isExport value.
     */
    Boolean isExport();

    /**
     * Gets the isSynced property: value indicating if last synchronization was later than the configuration change.
     * 
     * @return the isSynced value.
     */
    Boolean isSynced();

    /**
     * Gets the isGitEnabled property: value indicating whether Git configuration access is enabled.
     * 
     * @return the isGitEnabled value.
     */
    Boolean isGitEnabled();

    /**
     * Gets the syncDate property: The date of the latest synchronization. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the syncDate value.
     */
    OffsetDateTime syncDate();

    /**
     * Gets the configurationChangeDate property: The date of the latest configuration change. The date conforms to the
     * following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the configurationChangeDate value.
     */
    OffsetDateTime configurationChangeDate();

    /**
     * Gets the lastOperationId property: Most recent tenant configuration operation identifier.
     * 
     * @return the lastOperationId value.
     */
    String lastOperationId();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.TenantConfigurationSyncStateContractInner
     * object.
     * 
     * @return the inner object.
     */
    TenantConfigurationSyncStateContractInner innerModel();
}
