// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Terms of service contract properties.
 */
@Fluent
public final class TermsOfServiceProperties implements JsonSerializable<TermsOfServiceProperties> {
    /*
     * A terms of service text.
     */
    private String text;

    /*
     * Display terms of service during a sign-up process.
     */
    private Boolean enabled;

    /*
     * Ask user for consent to the terms of service.
     */
    private Boolean consentRequired;

    /**
     * Creates an instance of TermsOfServiceProperties class.
     */
    public TermsOfServiceProperties() {
    }

    /**
     * Get the text property: A terms of service text.
     * 
     * @return the text value.
     */
    public String text() {
        return this.text;
    }

    /**
     * Set the text property: A terms of service text.
     * 
     * @param text the text value to set.
     * @return the TermsOfServiceProperties object itself.
     */
    public TermsOfServiceProperties withText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the enabled property: Display terms of service during a sign-up process.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Display terms of service during a sign-up process.
     * 
     * @param enabled the enabled value to set.
     * @return the TermsOfServiceProperties object itself.
     */
    public TermsOfServiceProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the consentRequired property: Ask user for consent to the terms of service.
     * 
     * @return the consentRequired value.
     */
    public Boolean consentRequired() {
        return this.consentRequired;
    }

    /**
     * Set the consentRequired property: Ask user for consent to the terms of service.
     * 
     * @param consentRequired the consentRequired value to set.
     * @return the TermsOfServiceProperties object itself.
     */
    public TermsOfServiceProperties withConsentRequired(Boolean consentRequired) {
        this.consentRequired = consentRequired;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeBooleanField("consentRequired", this.consentRequired);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TermsOfServiceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TermsOfServiceProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TermsOfServiceProperties.
     */
    public static TermsOfServiceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TermsOfServiceProperties deserializedTermsOfServiceProperties = new TermsOfServiceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    deserializedTermsOfServiceProperties.text = reader.getString();
                } else if ("enabled".equals(fieldName)) {
                    deserializedTermsOfServiceProperties.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("consentRequired".equals(fieldName)) {
                    deserializedTermsOfServiceProperties.consentRequired = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTermsOfServiceProperties;
        });
    }
}
