// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * OAuth acquire token request body parameter (www-url-form-encoded).
 */
@Fluent
public final class TokenBodyParameterContract implements JsonSerializable<TokenBodyParameterContract> {
    /*
     * body parameter name.
     */
    private String name;

    /*
     * body parameter value.
     */
    private String value;

    /**
     * Creates an instance of TokenBodyParameterContract class.
     */
    public TokenBodyParameterContract() {
    }

    /**
     * Get the name property: body parameter name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: body parameter name.
     * 
     * @param name the name value to set.
     * @return the TokenBodyParameterContract object itself.
     */
    public TokenBodyParameterContract withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: body parameter value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: body parameter value.
     * 
     * @param value the value value to set.
     * @return the TokenBodyParameterContract object itself.
     */
    public TokenBodyParameterContract withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property name in model TokenBodyParameterContract"));
        }
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model TokenBodyParameterContract"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TokenBodyParameterContract.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TokenBodyParameterContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TokenBodyParameterContract if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TokenBodyParameterContract.
     */
    public static TokenBodyParameterContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TokenBodyParameterContract deserializedTokenBodyParameterContract = new TokenBodyParameterContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedTokenBodyParameterContract.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedTokenBodyParameterContract.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTokenBodyParameterContract;
        });
    }
}
