// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.UserCreateParameterProperties;
import com.azure.resourcemanager.apimanagement.fluent.models.UserIdentityContractInner;
import java.io.IOException;
import java.util.List;

/**
 * User create details.
 */
@Fluent
public final class UserCreateParameters implements JsonSerializable<UserCreateParameters> {
    /*
     * User entity create contract properties.
     */
    private UserCreateParameterProperties innerProperties;

    /**
     * Creates an instance of UserCreateParameters class.
     */
    public UserCreateParameters() {
    }

    /**
     * Get the innerProperties property: User entity create contract properties.
     * 
     * @return the innerProperties value.
     */
    private UserCreateParameterProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the email property: Email address. Must not be empty and must be unique within the service instance.
     * 
     * @return the email value.
     */
    public String email() {
        return this.innerProperties() == null ? null : this.innerProperties().email();
    }

    /**
     * Set the email property: Email address. Must not be empty and must be unique within the service instance.
     * 
     * @param email the email value to set.
     * @return the UserCreateParameters object itself.
     */
    public UserCreateParameters withEmail(String email) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserCreateParameterProperties();
        }
        this.innerProperties().withEmail(email);
        return this;
    }

    /**
     * Get the firstName property: First name.
     * 
     * @return the firstName value.
     */
    public String firstName() {
        return this.innerProperties() == null ? null : this.innerProperties().firstName();
    }

    /**
     * Set the firstName property: First name.
     * 
     * @param firstName the firstName value to set.
     * @return the UserCreateParameters object itself.
     */
    public UserCreateParameters withFirstName(String firstName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserCreateParameterProperties();
        }
        this.innerProperties().withFirstName(firstName);
        return this;
    }

    /**
     * Get the lastName property: Last name.
     * 
     * @return the lastName value.
     */
    public String lastName() {
        return this.innerProperties() == null ? null : this.innerProperties().lastName();
    }

    /**
     * Set the lastName property: Last name.
     * 
     * @param lastName the lastName value to set.
     * @return the UserCreateParameters object itself.
     */
    public UserCreateParameters withLastName(String lastName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserCreateParameterProperties();
        }
        this.innerProperties().withLastName(lastName);
        return this;
    }

    /**
     * Get the password property: User Password. If no value is provided, a default password is generated.
     * 
     * @return the password value.
     */
    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    /**
     * Set the password property: User Password. If no value is provided, a default password is generated.
     * 
     * @param password the password value to set.
     * @return the UserCreateParameters object itself.
     */
    public UserCreateParameters withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserCreateParameterProperties();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    /**
     * Get the appType property: Determines the type of application which send the create user request. Default is
     * legacy portal.
     * 
     * @return the appType value.
     */
    public AppType appType() {
        return this.innerProperties() == null ? null : this.innerProperties().appType();
    }

    /**
     * Set the appType property: Determines the type of application which send the create user request. Default is
     * legacy portal.
     * 
     * @param appType the appType value to set.
     * @return the UserCreateParameters object itself.
     */
    public UserCreateParameters withAppType(AppType appType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserCreateParameterProperties();
        }
        this.innerProperties().withAppType(appType);
        return this;
    }

    /**
     * Get the confirmation property: Determines the type of confirmation e-mail that will be sent to the newly created
     * user.
     * 
     * @return the confirmation value.
     */
    public Confirmation confirmation() {
        return this.innerProperties() == null ? null : this.innerProperties().confirmation();
    }

    /**
     * Set the confirmation property: Determines the type of confirmation e-mail that will be sent to the newly created
     * user.
     * 
     * @param confirmation the confirmation value to set.
     * @return the UserCreateParameters object itself.
     */
    public UserCreateParameters withConfirmation(Confirmation confirmation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserCreateParameterProperties();
        }
        this.innerProperties().withConfirmation(confirmation);
        return this;
    }

    /**
     * Get the state property: Account state. Specifies whether the user is active or not. Blocked users are unable to
     * sign into the developer portal or call any APIs of subscribed products. Default state is Active.
     * 
     * @return the state value.
     */
    public UserState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: Account state. Specifies whether the user is active or not. Blocked users are unable to
     * sign into the developer portal or call any APIs of subscribed products. Default state is Active.
     * 
     * @param state the state value to set.
     * @return the UserCreateParameters object itself.
     */
    public UserCreateParameters withState(UserState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserCreateParameterProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Get the note property: Optional note about a user set by the administrator.
     * 
     * @return the note value.
     */
    public String note() {
        return this.innerProperties() == null ? null : this.innerProperties().note();
    }

    /**
     * Set the note property: Optional note about a user set by the administrator.
     * 
     * @param note the note value to set.
     * @return the UserCreateParameters object itself.
     */
    public UserCreateParameters withNote(String note) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserCreateParameterProperties();
        }
        this.innerProperties().withNote(note);
        return this;
    }

    /**
     * Get the identities property: Collection of user identities.
     * 
     * @return the identities value.
     */
    public List<UserIdentityContractInner> identities() {
        return this.innerProperties() == null ? null : this.innerProperties().identities();
    }

    /**
     * Set the identities property: Collection of user identities.
     * 
     * @param identities the identities value to set.
     * @return the UserCreateParameters object itself.
     */
    public UserCreateParameters withIdentities(List<UserIdentityContractInner> identities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserCreateParameterProperties();
        }
        this.innerProperties().withIdentities(identities);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserCreateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserCreateParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UserCreateParameters.
     */
    public static UserCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserCreateParameters deserializedUserCreateParameters = new UserCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedUserCreateParameters.innerProperties = UserCreateParameterProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserCreateParameters;
        });
    }
}
