// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer
 * portal or call any APIs of subscribed products. Default state is Active.
 */
public final class UserState extends ExpandableStringEnum<UserState> {
    /**
     * Static value active for UserState.
     */
    public static final UserState ACTIVE = fromString("active");

    /**
     * Static value blocked for UserState.
     */
    public static final UserState BLOCKED = fromString("blocked");

    /**
     * Static value pending for UserState.
     */
    public static final UserState PENDING = fromString("pending");

    /**
     * Static value deleted for UserState.
     */
    public static final UserState DELETED = fromString("deleted");

    /**
     * Creates a new instance of UserState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public UserState() {
    }

    /**
     * Creates or finds a UserState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding UserState.
     */
    public static UserState fromString(String name) {
        return fromString(name, UserState.class);
    }

    /**
     * Gets known UserState values.
     * 
     * @return known UserState values.
     */
    public static Collection<UserState> values() {
        return values(UserState.class);
    }
}
