// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.UserTokenParameterProperties;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Get User Token parameters.
 */
@Fluent
public final class UserTokenParameters implements JsonSerializable<UserTokenParameters> {
    /*
     * User Token Parameter contract properties.
     */
    private UserTokenParameterProperties innerProperties;

    /**
     * Creates an instance of UserTokenParameters class.
     */
    public UserTokenParameters() {
    }

    /**
     * Get the innerProperties property: User Token Parameter contract properties.
     * 
     * @return the innerProperties value.
     */
    private UserTokenParameterProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the keyType property: The Key to be used to generate token for user.
     * 
     * @return the keyType value.
     */
    public KeyType keyType() {
        return this.innerProperties() == null ? null : this.innerProperties().keyType();
    }

    /**
     * Set the keyType property: The Key to be used to generate token for user.
     * 
     * @param keyType the keyType value to set.
     * @return the UserTokenParameters object itself.
     */
    public UserTokenParameters withKeyType(KeyType keyType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserTokenParameterProperties();
        }
        this.innerProperties().withKeyType(keyType);
        return this;
    }

    /**
     * Get the expiry property: The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date
     * conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the expiry value.
     */
    public OffsetDateTime expiry() {
        return this.innerProperties() == null ? null : this.innerProperties().expiry();
    }

    /**
     * Set the expiry property: The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date
     * conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param expiry the expiry value to set.
     * @return the UserTokenParameters object itself.
     */
    public UserTokenParameters withExpiry(OffsetDateTime expiry) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserTokenParameterProperties();
        }
        this.innerProperties().withExpiry(expiry);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserTokenParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserTokenParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the UserTokenParameters.
     */
    public static UserTokenParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserTokenParameters deserializedUserTokenParameters = new UserTokenParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedUserTokenParameters.innerProperties = UserTokenParameterProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserTokenParameters;
        });
    }
}
