// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.UserIdentityContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.UserUpdateParametersProperties;
import java.io.IOException;
import java.util.List;

/**
 * User update parameters.
 */
@Fluent
public final class UserUpdateParameters implements JsonSerializable<UserUpdateParameters> {
    /*
     * User entity update contract properties.
     */
    private UserUpdateParametersProperties innerProperties;

    /**
     * Creates an instance of UserUpdateParameters class.
     */
    public UserUpdateParameters() {
    }

    /**
     * Get the innerProperties property: User entity update contract properties.
     * 
     * @return the innerProperties value.
     */
    private UserUpdateParametersProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the email property: Email address. Must not be empty and must be unique within the service instance.
     * 
     * @return the email value.
     */
    public String email() {
        return this.innerProperties() == null ? null : this.innerProperties().email();
    }

    /**
     * Set the email property: Email address. Must not be empty and must be unique within the service instance.
     * 
     * @param email the email value to set.
     * @return the UserUpdateParameters object itself.
     */
    public UserUpdateParameters withEmail(String email) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserUpdateParametersProperties();
        }
        this.innerProperties().withEmail(email);
        return this;
    }

    /**
     * Get the password property: User Password.
     * 
     * @return the password value.
     */
    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    /**
     * Set the password property: User Password.
     * 
     * @param password the password value to set.
     * @return the UserUpdateParameters object itself.
     */
    public UserUpdateParameters withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserUpdateParametersProperties();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    /**
     * Get the firstName property: First name.
     * 
     * @return the firstName value.
     */
    public String firstName() {
        return this.innerProperties() == null ? null : this.innerProperties().firstName();
    }

    /**
     * Set the firstName property: First name.
     * 
     * @param firstName the firstName value to set.
     * @return the UserUpdateParameters object itself.
     */
    public UserUpdateParameters withFirstName(String firstName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserUpdateParametersProperties();
        }
        this.innerProperties().withFirstName(firstName);
        return this;
    }

    /**
     * Get the lastName property: Last name.
     * 
     * @return the lastName value.
     */
    public String lastName() {
        return this.innerProperties() == null ? null : this.innerProperties().lastName();
    }

    /**
     * Set the lastName property: Last name.
     * 
     * @param lastName the lastName value to set.
     * @return the UserUpdateParameters object itself.
     */
    public UserUpdateParameters withLastName(String lastName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserUpdateParametersProperties();
        }
        this.innerProperties().withLastName(lastName);
        return this;
    }

    /**
     * Get the state property: Account state. Specifies whether the user is active or not. Blocked users are unable to
     * sign into the developer portal or call any APIs of subscribed products. Default state is Active.
     * 
     * @return the state value.
     */
    public UserState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: Account state. Specifies whether the user is active or not. Blocked users are unable to
     * sign into the developer portal or call any APIs of subscribed products. Default state is Active.
     * 
     * @param state the state value to set.
     * @return the UserUpdateParameters object itself.
     */
    public UserUpdateParameters withState(UserState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserUpdateParametersProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Get the note property: Optional note about a user set by the administrator.
     * 
     * @return the note value.
     */
    public String note() {
        return this.innerProperties() == null ? null : this.innerProperties().note();
    }

    /**
     * Set the note property: Optional note about a user set by the administrator.
     * 
     * @param note the note value to set.
     * @return the UserUpdateParameters object itself.
     */
    public UserUpdateParameters withNote(String note) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserUpdateParametersProperties();
        }
        this.innerProperties().withNote(note);
        return this;
    }

    /**
     * Get the identities property: Collection of user identities.
     * 
     * @return the identities value.
     */
    public List<UserIdentityContractInner> identities() {
        return this.innerProperties() == null ? null : this.innerProperties().identities();
    }

    /**
     * Set the identities property: Collection of user identities.
     * 
     * @param identities the identities value to set.
     * @return the UserUpdateParameters object itself.
     */
    public UserUpdateParameters withIdentities(List<UserIdentityContractInner> identities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserUpdateParametersProperties();
        }
        this.innerProperties().withIdentities(identities);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserUpdateParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UserUpdateParameters.
     */
    public static UserUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserUpdateParameters deserializedUserUpdateParameters = new UserUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedUserUpdateParameters.innerProperties = UserUpdateParametersProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserUpdateParameters;
        });
    }
}
