// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The verbosity level applied to traces emitted by trace policies.
 */
public final class Verbosity extends ExpandableStringEnum<Verbosity> {
    /**
     * Static value verbose for Verbosity.
     */
    public static final Verbosity VERBOSE = fromString("verbose");

    /**
     * Static value information for Verbosity.
     */
    public static final Verbosity INFORMATION = fromString("information");

    /**
     * Static value error for Verbosity.
     */
    public static final Verbosity ERROR = fromString("error");

    /**
     * Creates a new instance of Verbosity value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public Verbosity() {
    }

    /**
     * Creates or finds a Verbosity from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding Verbosity.
     */
    public static Verbosity fromString(String name) {
        return fromString(name, Verbosity.class);
    }

    /**
     * Gets known Verbosity values.
     * 
     * @return known Verbosity values.
     */
    public static Collection<Verbosity> values() {
        return values(Verbosity.class);
    }
}
