// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * An value that determines where the API Version identifier will be located in a HTTP request.
 */
public final class VersioningScheme extends ExpandableStringEnum<VersioningScheme> {
    /**
     * Static value Segment for VersioningScheme.
     */
    public static final VersioningScheme SEGMENT = fromString("Segment");

    /**
     * Static value Query for VersioningScheme.
     */
    public static final VersioningScheme QUERY = fromString("Query");

    /**
     * Static value Header for VersioningScheme.
     */
    public static final VersioningScheme HEADER = fromString("Header");

    /**
     * Creates a new instance of VersioningScheme value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public VersioningScheme() {
    }

    /**
     * Creates or finds a VersioningScheme from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding VersioningScheme.
     */
    public static VersioningScheme fromString(String name) {
        return fromString(name, VersioningScheme.class);
    }

    /**
     * Gets known VersioningScheme values.
     * 
     * @return known VersioningScheme values.
     */
    public static Collection<VersioningScheme> values() {
        return values(VersioningScheme.class);
    }
}
