// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.WikiContractInner;
import java.io.IOException;
import java.util.List;

/**
 * Paged Wiki list representation.
 */
@Immutable
public final class WikiCollection implements JsonSerializable<WikiCollection> {
    /*
     * Page values.
     */
    private List<WikiContractInner> value;

    /*
     * Next page link if any.
     */
    private String nextLink;

    /**
     * Creates an instance of WikiCollection class.
     */
    public WikiCollection() {
    }

    /**
     * Get the value property: Page values.
     * 
     * @return the value value.
     */
    public List<WikiContractInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Next page link if any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WikiCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WikiCollection if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the WikiCollection.
     */
    public static WikiCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WikiCollection deserializedWikiCollection = new WikiCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<WikiContractInner> value = reader.readArray(reader1 -> WikiContractInner.fromJson(reader1));
                    deserializedWikiCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedWikiCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWikiCollection;
        });
    }
}
