// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.WorkspaceContractInner;

/**
 * An immutable client-side representation of WorkspaceContract.
 */
public interface WorkspaceContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the displayName property: Name of the workspace.
     * 
     * @return the displayName value.
     */
    String displayName();

    /**
     * Gets the description property: Description of the workspace.
     * 
     * @return the description value.
     */
    String description();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.WorkspaceContractInner object.
     * 
     * @return the inner object.
     */
    WorkspaceContractInner innerModel();

    /**
     * The entirety of the WorkspaceContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The WorkspaceContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the WorkspaceContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the WorkspaceContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @return the next definition stage.
             */
            WithCreate withExistingService(String resourceGroupName, String serviceName);
        }

        /**
         * The stage of the WorkspaceContract definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate
            extends DefinitionStages.WithDisplayName, DefinitionStages.WithDescription, DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            WorkspaceContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            WorkspaceContract create(Context context);
        }

        /**
         * The stage of the WorkspaceContract definition allowing to specify displayName.
         */
        interface WithDisplayName {
            /**
             * Specifies the displayName property: Name of the workspace..
             * 
             * @param displayName Name of the workspace.
             * @return the next definition stage.
             */
            WithCreate withDisplayName(String displayName);
        }

        /**
         * The stage of the WorkspaceContract definition allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Description of the workspace..
             * 
             * @param description Description of the workspace.
             * @return the next definition stage.
             */
            WithCreate withDescription(String description);
        }

        /**
         * The stage of the WorkspaceContract definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the WorkspaceContract resource.
     * 
     * @return the stage of resource update.
     */
    WorkspaceContract.Update update();

    /**
     * The template for WorkspaceContract update.
     */
    interface Update extends UpdateStages.WithDisplayName, UpdateStages.WithDescription, UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        WorkspaceContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        WorkspaceContract apply(Context context);
    }

    /**
     * The WorkspaceContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the WorkspaceContract update allowing to specify displayName.
         */
        interface WithDisplayName {
            /**
             * Specifies the displayName property: Name of the workspace..
             * 
             * @param displayName Name of the workspace.
             * @return the next definition stage.
             */
            Update withDisplayName(String displayName);
        }

        /**
         * The stage of the WorkspaceContract update allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Description of the workspace..
             * 
             * @param description Description of the workspace.
             * @return the next definition stage.
             */
            Update withDescription(String description);
        }

        /**
         * The stage of the WorkspaceContract update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. ETag should match the current entity state from the
             * header response of the GET request or it should be * for unconditional update..
             * 
             * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of
             * the GET request or it should be * for unconditional update.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    WorkspaceContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    WorkspaceContract refresh(Context context);
}
