// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The WorkspaceLinksBaseProperties model.
 */
@Fluent
public class WorkspaceLinksBaseProperties implements JsonSerializable<WorkspaceLinksBaseProperties> {
    /*
     * The link to the API Management service workspace.
     */
    private String workspaceId;

    /*
     * The array of linked gateways.
     */
    private List<WorkspaceLinksGateway> gateways;

    /**
     * Creates an instance of WorkspaceLinksBaseProperties class.
     */
    public WorkspaceLinksBaseProperties() {
    }

    /**
     * Get the workspaceId property: The link to the API Management service workspace.
     * 
     * @return the workspaceId value.
     */
    public String workspaceId() {
        return this.workspaceId;
    }

    /**
     * Set the workspaceId property: The link to the API Management service workspace.
     * 
     * @param workspaceId the workspaceId value to set.
     * @return the WorkspaceLinksBaseProperties object itself.
     */
    public WorkspaceLinksBaseProperties withWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    /**
     * Get the gateways property: The array of linked gateways.
     * 
     * @return the gateways value.
     */
    public List<WorkspaceLinksGateway> gateways() {
        return this.gateways;
    }

    /**
     * Set the gateways property: The array of linked gateways.
     * 
     * @param gateways the gateways value to set.
     * @return the WorkspaceLinksBaseProperties object itself.
     */
    public WorkspaceLinksBaseProperties withGateways(List<WorkspaceLinksGateway> gateways) {
        this.gateways = gateways;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (gateways() != null) {
            gateways().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("workspaceId", this.workspaceId);
        jsonWriter.writeArrayField("gateways", this.gateways, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkspaceLinksBaseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkspaceLinksBaseProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkspaceLinksBaseProperties.
     */
    public static WorkspaceLinksBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkspaceLinksBaseProperties deserializedWorkspaceLinksBaseProperties = new WorkspaceLinksBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("workspaceId".equals(fieldName)) {
                    deserializedWorkspaceLinksBaseProperties.workspaceId = reader.getString();
                } else if ("gateways".equals(fieldName)) {
                    List<WorkspaceLinksGateway> gateways
                        = reader.readArray(reader1 -> WorkspaceLinksGateway.fromJson(reader1));
                    deserializedWorkspaceLinksBaseProperties.gateways = gateways;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkspaceLinksBaseProperties;
        });
    }
}
