// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The WorkspaceLinksGateway model.
 */
@Fluent
public final class WorkspaceLinksGateway implements JsonSerializable<WorkspaceLinksGateway> {
    /*
     * The link to the API Management gateway.
     */
    private String id;

    /**
     * Creates an instance of WorkspaceLinksGateway class.
     */
    public WorkspaceLinksGateway() {
    }

    /**
     * Get the id property: The link to the API Management gateway.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The link to the API Management gateway.
     * 
     * @param id the id value to set.
     * @return the WorkspaceLinksGateway object itself.
     */
    public WorkspaceLinksGateway withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkspaceLinksGateway from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkspaceLinksGateway if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkspaceLinksGateway.
     */
    public static WorkspaceLinksGateway fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkspaceLinksGateway deserializedWorkspaceLinksGateway = new WorkspaceLinksGateway();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedWorkspaceLinksGateway.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkspaceLinksGateway;
        });
    }
}
