// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductGroupLinkContractInner;

/**
 * Resource collection API of WorkspaceProductGroupLinks.
 */
public interface WorkspaceProductGroupLinks {
    /**
     * Lists a collection of the group links associated with a product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Product-group link list representation as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ProductGroupLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String workspaceId, String productId);

    /**
     * Lists a collection of the group links associated with a product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| groupId | filter | ge, le, eq,
     * ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Product-group link list representation as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ProductGroupLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String workspaceId, String productId, String filter, Integer top, Integer skip, Context context);

    /**
     * Gets the group link for the product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param groupLinkId Product-Group link identifier. Must be unique in the current API Management service instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the group link for the product.
     */
    Response<ProductGroupLinkContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String productId, String groupLinkId, Context context);

    /**
     * Gets the group link for the product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param groupLinkId Product-Group link identifier. Must be unique in the current API Management service instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the group link for the product.
     */
    ProductGroupLinkContract get(String resourceGroupName, String serviceName, String workspaceId, String productId,
        String groupLinkId);

    /**
     * Adds a group to the specified product via link.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param groupLinkId Product-Group link identifier. Must be unique in the current API Management service instance.
     * @param parameters Create or update parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return product-group link details along with {@link Response}.
     */
    Response<ProductGroupLinkContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String productId, String groupLinkId, ProductGroupLinkContractInner parameters,
        Context context);

    /**
     * Adds a group to the specified product via link.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param groupLinkId Product-Group link identifier. Must be unique in the current API Management service instance.
     * @param parameters Create or update parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return product-group link details.
     */
    ProductGroupLinkContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        String productId, String groupLinkId, ProductGroupLinkContractInner parameters);

    /**
     * Deletes the specified group from the specified product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param groupLinkId Product-Group link identifier. Must be unique in the current API Management service instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String productId, String groupLinkId, Context context);

    /**
     * Deletes the specified group from the specified product.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param workspaceId Workspace identifier. Must be unique in the current API Management service instance.
     * @param productId Product identifier. Must be unique in the current API Management service instance.
     * @param groupLinkId Product-Group link identifier. Must be unique in the current API Management service instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String serviceName, String workspaceId, String productId, String groupLinkId);
}
