// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of server X509Names.
 */
@Fluent
public final class X509CertificateName implements JsonSerializable<X509CertificateName> {
    /*
     * Common Name of the Certificate.
     */
    private String name;

    /*
     * Thumbprint for the Issuer of the Certificate.
     */
    private String issuerCertificateThumbprint;

    /**
     * Creates an instance of X509CertificateName class.
     */
    public X509CertificateName() {
    }

    /**
     * Get the name property: Common Name of the Certificate.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Common Name of the Certificate.
     * 
     * @param name the name value to set.
     * @return the X509CertificateName object itself.
     */
    public X509CertificateName withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the issuerCertificateThumbprint property: Thumbprint for the Issuer of the Certificate.
     * 
     * @return the issuerCertificateThumbprint value.
     */
    public String issuerCertificateThumbprint() {
        return this.issuerCertificateThumbprint;
    }

    /**
     * Set the issuerCertificateThumbprint property: Thumbprint for the Issuer of the Certificate.
     * 
     * @param issuerCertificateThumbprint the issuerCertificateThumbprint value to set.
     * @return the X509CertificateName object itself.
     */
    public X509CertificateName withIssuerCertificateThumbprint(String issuerCertificateThumbprint) {
        this.issuerCertificateThumbprint = issuerCertificateThumbprint;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("issuerCertificateThumbprint", this.issuerCertificateThumbprint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of X509CertificateName from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of X509CertificateName if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the X509CertificateName.
     */
    public static X509CertificateName fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            X509CertificateName deserializedX509CertificateName = new X509CertificateName();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedX509CertificateName.name = reader.getString();
                } else if ("issuerCertificateThumbprint".equals(fieldName)) {
                    deserializedX509CertificateName.issuerCertificateThumbprint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedX509CertificateName;
        });
    }
}
