/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiContactInformation;
import com.azure.resourcemanager.apimanagement.models.ApiEntityBaseContract;
import com.azure.resourcemanager.apimanagement.models.ApiLicenseInformation;
import com.azure.resourcemanager.apimanagement.models.ApiType;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetContractDetails;
import com.azure.resourcemanager.apimanagement.models.AuthenticationSettingsContract;
import com.azure.resourcemanager.apimanagement.models.Protocol;
import com.azure.resourcemanager.apimanagement.models.SubscriptionKeyParameterNamesContract;
import java.io.IOException;
import java.util.List;

public class ApiContractProperties
extends ApiEntityBaseContract {
    private String sourceApiId;
    private String displayName;
    private String serviceUrl;
    private String path;
    private List<Protocol> protocols;
    private ApiVersionSetContractDetails apiVersionSet;
    private String provisioningState;
    private Boolean isOnline;
    private static final ClientLogger LOGGER = new ClientLogger(ApiContractProperties.class);

    public String sourceApiId() {
        return this.sourceApiId;
    }

    public ApiContractProperties withSourceApiId(String sourceApiId) {
        this.sourceApiId = sourceApiId;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public ApiContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String serviceUrl() {
        return this.serviceUrl;
    }

    public ApiContractProperties withServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    public String path() {
        return this.path;
    }

    public ApiContractProperties withPath(String path) {
        this.path = path;
        return this;
    }

    public List<Protocol> protocols() {
        return this.protocols;
    }

    public ApiContractProperties withProtocols(List<Protocol> protocols) {
        this.protocols = protocols;
        return this;
    }

    public ApiVersionSetContractDetails apiVersionSet() {
        return this.apiVersionSet;
    }

    public ApiContractProperties withApiVersionSet(ApiVersionSetContractDetails apiVersionSet) {
        this.apiVersionSet = apiVersionSet;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    ApiContractProperties withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    @Override
    public Boolean isOnline() {
        return this.isOnline;
    }

    @Override
    public ApiContractProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ApiContractProperties withAuthenticationSettings(AuthenticationSettingsContract authenticationSettings) {
        super.withAuthenticationSettings(authenticationSettings);
        return this;
    }

    @Override
    public ApiContractProperties withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames) {
        super.withSubscriptionKeyParameterNames(subscriptionKeyParameterNames);
        return this;
    }

    @Override
    public ApiContractProperties withApiType(ApiType apiType) {
        super.withApiType(apiType);
        return this;
    }

    @Override
    public ApiContractProperties withApiRevision(String apiRevision) {
        super.withApiRevision(apiRevision);
        return this;
    }

    @Override
    public ApiContractProperties withApiVersion(String apiVersion) {
        super.withApiVersion(apiVersion);
        return this;
    }

    @Override
    public ApiContractProperties withIsCurrent(Boolean isCurrent) {
        super.withIsCurrent(isCurrent);
        return this;
    }

    @Override
    public ApiContractProperties withApiRevisionDescription(String apiRevisionDescription) {
        super.withApiRevisionDescription(apiRevisionDescription);
        return this;
    }

    @Override
    public ApiContractProperties withApiVersionDescription(String apiVersionDescription) {
        super.withApiVersionDescription(apiVersionDescription);
        return this;
    }

    @Override
    public ApiContractProperties withApiVersionSetId(String apiVersionSetId) {
        super.withApiVersionSetId(apiVersionSetId);
        return this;
    }

    @Override
    public ApiContractProperties withSubscriptionRequired(Boolean subscriptionRequired) {
        super.withSubscriptionRequired(subscriptionRequired);
        return this;
    }

    @Override
    public ApiContractProperties withTermsOfServiceUrl(String termsOfServiceUrl) {
        super.withTermsOfServiceUrl(termsOfServiceUrl);
        return this;
    }

    @Override
    public ApiContractProperties withContact(ApiContactInformation contact) {
        super.withContact(contact);
        return this;
    }

    @Override
    public ApiContractProperties withLicense(ApiLicenseInformation license) {
        super.withLicense(license);
        return this;
    }

    @Override
    public void validate() {
        if (this.path() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property path in model ApiContractProperties"));
        }
        if (this.apiVersionSet() != null) {
            this.apiVersionSet().validate();
        }
        if (this.authenticationSettings() != null) {
            this.authenticationSettings().validate();
        }
        if (this.subscriptionKeyParameterNames() != null) {
            this.subscriptionKeyParameterNames().validate();
        }
        if (this.contact() != null) {
            this.contact().validate();
        }
        if (this.license() != null) {
            this.license().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeJsonField("authenticationSettings", (JsonSerializable)this.authenticationSettings());
        jsonWriter.writeJsonField("subscriptionKeyParameterNames", (JsonSerializable)this.subscriptionKeyParameterNames());
        jsonWriter.writeStringField("type", this.apiType() == null ? null : this.apiType().toString());
        jsonWriter.writeStringField("apiRevision", this.apiRevision());
        jsonWriter.writeStringField("apiVersion", this.apiVersion());
        jsonWriter.writeBooleanField("isCurrent", this.isCurrent());
        jsonWriter.writeStringField("apiRevisionDescription", this.apiRevisionDescription());
        jsonWriter.writeStringField("apiVersionDescription", this.apiVersionDescription());
        jsonWriter.writeStringField("apiVersionSetId", this.apiVersionSetId());
        jsonWriter.writeBooleanField("subscriptionRequired", this.subscriptionRequired());
        jsonWriter.writeStringField("termsOfServiceUrl", this.termsOfServiceUrl());
        jsonWriter.writeJsonField("contact", (JsonSerializable)this.contact());
        jsonWriter.writeJsonField("license", (JsonSerializable)this.license());
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("sourceApiId", this.sourceApiId);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("serviceUrl", this.serviceUrl);
        jsonWriter.writeArrayField("protocols", this.protocols, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("apiVersionSet", (JsonSerializable)this.apiVersionSet);
        return jsonWriter.writeEndObject();
    }

    public static ApiContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiContractProperties)jsonReader.readObject(reader -> {
            ApiContractProperties deserializedApiContractProperties = new ApiContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedApiContractProperties.withDescription(reader.getString());
                    continue;
                }
                if ("authenticationSettings".equals(fieldName)) {
                    deserializedApiContractProperties.withAuthenticationSettings(AuthenticationSettingsContract.fromJson(reader));
                    continue;
                }
                if ("subscriptionKeyParameterNames".equals(fieldName)) {
                    deserializedApiContractProperties.withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApiContractProperties.withApiType(ApiType.fromString(reader.getString()));
                    continue;
                }
                if ("apiRevision".equals(fieldName)) {
                    deserializedApiContractProperties.withApiRevision(reader.getString());
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    deserializedApiContractProperties.withApiVersion(reader.getString());
                    continue;
                }
                if ("isCurrent".equals(fieldName)) {
                    deserializedApiContractProperties.withIsCurrent((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("isOnline".equals(fieldName)) {
                    deserializedApiContractProperties.isOnline = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("apiRevisionDescription".equals(fieldName)) {
                    deserializedApiContractProperties.withApiRevisionDescription(reader.getString());
                    continue;
                }
                if ("apiVersionDescription".equals(fieldName)) {
                    deserializedApiContractProperties.withApiVersionDescription(reader.getString());
                    continue;
                }
                if ("apiVersionSetId".equals(fieldName)) {
                    deserializedApiContractProperties.withApiVersionSetId(reader.getString());
                    continue;
                }
                if ("subscriptionRequired".equals(fieldName)) {
                    deserializedApiContractProperties.withSubscriptionRequired((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("termsOfServiceUrl".equals(fieldName)) {
                    deserializedApiContractProperties.withTermsOfServiceUrl(reader.getString());
                    continue;
                }
                if ("contact".equals(fieldName)) {
                    deserializedApiContractProperties.withContact(ApiContactInformation.fromJson(reader));
                    continue;
                }
                if ("license".equals(fieldName)) {
                    deserializedApiContractProperties.withLicense(ApiLicenseInformation.fromJson(reader));
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedApiContractProperties.path = reader.getString();
                    continue;
                }
                if ("sourceApiId".equals(fieldName)) {
                    deserializedApiContractProperties.sourceApiId = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedApiContractProperties.displayName = reader.getString();
                    continue;
                }
                if ("serviceUrl".equals(fieldName)) {
                    deserializedApiContractProperties.serviceUrl = reader.getString();
                    continue;
                }
                if ("protocols".equals(fieldName)) {
                    List protocols;
                    deserializedApiContractProperties.protocols = protocols = reader.readArray(reader1 -> Protocol.fromString(reader1.getString()));
                    continue;
                }
                if ("apiVersionSet".equals(fieldName)) {
                    deserializedApiContractProperties.apiVersionSet = ApiVersionSetContractDetails.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApiContractProperties.provisioningState = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiContractProperties;
        });
    }
}

