/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiExportResultValue;
import com.azure.resourcemanager.apimanagement.models.ExportResultFormat;
import java.io.IOException;

public final class ApiExportResultInner
implements JsonSerializable<ApiExportResultInner> {
    private String id;
    private ExportResultFormat exportResultFormat;
    private ApiExportResultValue value;

    public String id() {
        return this.id;
    }

    public ApiExportResultInner withId(String id) {
        this.id = id;
        return this;
    }

    public ExportResultFormat exportResultFormat() {
        return this.exportResultFormat;
    }

    public ApiExportResultInner withExportResultFormat(ExportResultFormat exportResultFormat) {
        this.exportResultFormat = exportResultFormat;
        return this;
    }

    public ApiExportResultValue value() {
        return this.value;
    }

    public ApiExportResultInner withValue(ApiExportResultValue value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("format", this.exportResultFormat == null ? null : this.exportResultFormat.toString());
        jsonWriter.writeJsonField("value", (JsonSerializable)this.value);
        return jsonWriter.writeEndObject();
    }

    public static ApiExportResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApiExportResultInner)jsonReader.readObject(reader -> {
            ApiExportResultInner deserializedApiExportResultInner = new ApiExportResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApiExportResultInner.id = reader.getString();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedApiExportResultInner.exportResultFormat = ExportResultFormat.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedApiExportResultInner.value = ApiExportResultValue.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiExportResultInner;
        });
    }
}

