/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayBaseProperties;
import com.azure.resourcemanager.apimanagement.models.BackendConfiguration;
import com.azure.resourcemanager.apimanagement.models.FrontendConfiguration;
import com.azure.resourcemanager.apimanagement.models.GatewayConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ApiManagementGatewayProperties
extends ApiManagementGatewayBaseProperties {
    private OffsetDateTime createdAtUtc;
    private String targetProvisioningState;
    private String provisioningState;

    @Override
    public OffsetDateTime createdAtUtc() {
        return this.createdAtUtc;
    }

    @Override
    public String targetProvisioningState() {
        return this.targetProvisioningState;
    }

    @Override
    public String provisioningState() {
        return this.provisioningState;
    }

    @Override
    public ApiManagementGatewayProperties withFrontend(FrontendConfiguration frontend) {
        super.withFrontend(frontend);
        return this;
    }

    @Override
    public ApiManagementGatewayProperties withBackend(BackendConfiguration backend) {
        super.withBackend(backend);
        return this;
    }

    @Override
    public ApiManagementGatewayProperties withConfigurationApi(GatewayConfigurationApi configurationApi) {
        super.withConfigurationApi(configurationApi);
        return this;
    }

    @Override
    public ApiManagementGatewayProperties withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        super.withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    @Override
    public void validate() {
        if (this.frontend() != null) {
            this.frontend().validate();
        }
        if (this.backend() != null) {
            this.backend().validate();
        }
        if (this.configurationApi() != null) {
            this.configurationApi().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("frontend", (JsonSerializable)this.frontend());
        jsonWriter.writeJsonField("backend", (JsonSerializable)this.backend());
        jsonWriter.writeJsonField("configurationApi", (JsonSerializable)this.configurationApi());
        jsonWriter.writeStringField("virtualNetworkType", this.virtualNetworkType() == null ? null : this.virtualNetworkType().toString());
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementGatewayProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementGatewayProperties)jsonReader.readObject(reader -> {
            ApiManagementGatewayProperties deserializedApiManagementGatewayProperties = new ApiManagementGatewayProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedApiManagementGatewayProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("targetProvisioningState".equals(fieldName)) {
                    deserializedApiManagementGatewayProperties.targetProvisioningState = reader.getString();
                    continue;
                }
                if ("createdAtUtc".equals(fieldName)) {
                    deserializedApiManagementGatewayProperties.createdAtUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("frontend".equals(fieldName)) {
                    deserializedApiManagementGatewayProperties.withFrontend(FrontendConfiguration.fromJson(reader));
                    continue;
                }
                if ("backend".equals(fieldName)) {
                    deserializedApiManagementGatewayProperties.withBackend(BackendConfiguration.fromJson(reader));
                    continue;
                }
                if ("configurationApi".equals(fieldName)) {
                    deserializedApiManagementGatewayProperties.withConfigurationApi(GatewayConfigurationApi.fromJson(reader));
                    continue;
                }
                if ("virtualNetworkType".equals(fieldName)) {
                    deserializedApiManagementGatewayProperties.withVirtualNetworkType(VirtualNetworkType.fromString(reader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementGatewayProperties;
        });
    }
}

