/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayBaseProperties;
import com.azure.resourcemanager.apimanagement.models.BackendConfiguration;
import com.azure.resourcemanager.apimanagement.models.FrontendConfiguration;
import com.azure.resourcemanager.apimanagement.models.GatewayConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ApiManagementGatewayUpdateProperties
extends ApiManagementGatewayBaseProperties {
    private OffsetDateTime createdAtUtc;
    private String targetProvisioningState;
    private String provisioningState;

    @Override
    public OffsetDateTime createdAtUtc() {
        return this.createdAtUtc;
    }

    @Override
    public String targetProvisioningState() {
        return this.targetProvisioningState;
    }

    @Override
    public String provisioningState() {
        return this.provisioningState;
    }

    @Override
    public ApiManagementGatewayUpdateProperties withFrontend(FrontendConfiguration frontend) {
        super.withFrontend(frontend);
        return this;
    }

    @Override
    public ApiManagementGatewayUpdateProperties withBackend(BackendConfiguration backend) {
        super.withBackend(backend);
        return this;
    }

    @Override
    public ApiManagementGatewayUpdateProperties withConfigurationApi(GatewayConfigurationApi configurationApi) {
        super.withConfigurationApi(configurationApi);
        return this;
    }

    @Override
    public ApiManagementGatewayUpdateProperties withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        super.withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    @Override
    public void validate() {
        if (this.frontend() != null) {
            this.frontend().validate();
        }
        if (this.backend() != null) {
            this.backend().validate();
        }
        if (this.configurationApi() != null) {
            this.configurationApi().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("frontend", (JsonSerializable)this.frontend());
        jsonWriter.writeJsonField("backend", (JsonSerializable)this.backend());
        jsonWriter.writeJsonField("configurationApi", (JsonSerializable)this.configurationApi());
        jsonWriter.writeStringField("virtualNetworkType", this.virtualNetworkType() == null ? null : this.virtualNetworkType().toString());
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementGatewayUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementGatewayUpdateProperties)jsonReader.readObject(reader -> {
            ApiManagementGatewayUpdateProperties deserializedApiManagementGatewayUpdateProperties = new ApiManagementGatewayUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("targetProvisioningState".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties.targetProvisioningState = reader.getString();
                    continue;
                }
                if ("createdAtUtc".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties.createdAtUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("frontend".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties.withFrontend(FrontendConfiguration.fromJson(reader));
                    continue;
                }
                if ("backend".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties.withBackend(BackendConfiguration.fromJson(reader));
                    continue;
                }
                if ("configurationApi".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties.withConfigurationApi(GatewayConfigurationApi.fromJson(reader));
                    continue;
                }
                if ("virtualNetworkType".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateProperties.withVirtualNetworkType(VirtualNetworkType.fromString(reader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementGatewayUpdateProperties;
        });
    }
}

