/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.WorkspaceLinksBaseProperties;
import com.azure.resourcemanager.apimanagement.models.WorkspaceLinksGateway;
import java.io.IOException;
import java.util.List;

public final class ApiManagementWorkspaceLinksProperties
extends WorkspaceLinksBaseProperties {
    @Override
    public ApiManagementWorkspaceLinksProperties withWorkspaceId(String workspaceId) {
        super.withWorkspaceId(workspaceId);
        return this;
    }

    @Override
    public ApiManagementWorkspaceLinksProperties withGateways(List<WorkspaceLinksGateway> gateways) {
        super.withGateways(gateways);
        return this;
    }

    @Override
    public void validate() {
        if (this.gateways() != null) {
            this.gateways().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("workspaceId", this.workspaceId());
        jsonWriter.writeArrayField("gateways", this.gateways(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementWorkspaceLinksProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementWorkspaceLinksProperties)jsonReader.readObject(reader -> {
            ApiManagementWorkspaceLinksProperties deserializedApiManagementWorkspaceLinksProperties = new ApiManagementWorkspaceLinksProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("workspaceId".equals(fieldName)) {
                    deserializedApiManagementWorkspaceLinksProperties.withWorkspaceId(reader.getString());
                    continue;
                }
                if ("gateways".equals(fieldName)) {
                    List gateways = reader.readArray(reader1 -> WorkspaceLinksGateway.fromJson(reader1));
                    deserializedApiManagementWorkspaceLinksProperties.withGateways(gateways);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementWorkspaceLinksProperties;
        });
    }
}

