/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetEntityBase;
import com.azure.resourcemanager.apimanagement.models.VersioningScheme;
import java.io.IOException;

public final class ApiVersionSetUpdateParametersProperties
extends ApiVersionSetEntityBase {
    private String displayName;
    private VersioningScheme versioningScheme;

    public String displayName() {
        return this.displayName;
    }

    public ApiVersionSetUpdateParametersProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public VersioningScheme versioningScheme() {
        return this.versioningScheme;
    }

    public ApiVersionSetUpdateParametersProperties withVersioningScheme(VersioningScheme versioningScheme) {
        this.versioningScheme = versioningScheme;
        return this;
    }

    @Override
    public ApiVersionSetUpdateParametersProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ApiVersionSetUpdateParametersProperties withVersionQueryName(String versionQueryName) {
        super.withVersionQueryName(versionQueryName);
        return this;
    }

    @Override
    public ApiVersionSetUpdateParametersProperties withVersionHeaderName(String versionHeaderName) {
        super.withVersionHeaderName(versionHeaderName);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("versionQueryName", this.versionQueryName());
        jsonWriter.writeStringField("versionHeaderName", this.versionHeaderName());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("versioningScheme", this.versioningScheme == null ? null : this.versioningScheme.toString());
        return jsonWriter.writeEndObject();
    }

    public static ApiVersionSetUpdateParametersProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiVersionSetUpdateParametersProperties)jsonReader.readObject(reader -> {
            ApiVersionSetUpdateParametersProperties deserializedApiVersionSetUpdateParametersProperties = new ApiVersionSetUpdateParametersProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedApiVersionSetUpdateParametersProperties.withDescription(reader.getString());
                    continue;
                }
                if ("versionQueryName".equals(fieldName)) {
                    deserializedApiVersionSetUpdateParametersProperties.withVersionQueryName(reader.getString());
                    continue;
                }
                if ("versionHeaderName".equals(fieldName)) {
                    deserializedApiVersionSetUpdateParametersProperties.withVersionHeaderName(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedApiVersionSetUpdateParametersProperties.displayName = reader.getString();
                    continue;
                }
                if ("versioningScheme".equals(fieldName)) {
                    deserializedApiVersionSetUpdateParametersProperties.versioningScheme = VersioningScheme.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiVersionSetUpdateParametersProperties;
        });
    }
}

