/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationContractProperties;
import com.azure.resourcemanager.apimanagement.models.AuthorizationError;
import com.azure.resourcemanager.apimanagement.models.AuthorizationType;
import com.azure.resourcemanager.apimanagement.models.OAuth2GrantType;
import java.io.IOException;
import java.util.Map;

public final class AuthorizationContractInner
extends ProxyResource {
    private AuthorizationContractProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private AuthorizationContractProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public AuthorizationType authorizationType() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizationType();
    }

    public AuthorizationContractInner withAuthorizationType(AuthorizationType authorizationType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationContractProperties();
        }
        this.innerProperties().withAuthorizationType(authorizationType);
        return this;
    }

    public OAuth2GrantType oAuth2GrantType() {
        return this.innerProperties() == null ? null : this.innerProperties().oAuth2GrantType();
    }

    public AuthorizationContractInner withOAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationContractProperties();
        }
        this.innerProperties().withOAuth2GrantType(oAuth2GrantType);
        return this;
    }

    public Map<String, String> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public AuthorizationContractInner withParameters(Map<String, String> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationContractProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public AuthorizationError error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    public AuthorizationContractInner withError(AuthorizationError error) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationContractProperties();
        }
        this.innerProperties().withError(error);
        return this;
    }

    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public AuthorizationContractInner withStatus(String status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationContractProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AuthorizationContractInner fromJson(JsonReader jsonReader) throws IOException {
        return (AuthorizationContractInner)((Object)jsonReader.readObject(reader -> {
            AuthorizationContractInner deserializedAuthorizationContractInner = new AuthorizationContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAuthorizationContractInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAuthorizationContractInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAuthorizationContractInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAuthorizationContractInner.innerProperties = AuthorizationContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthorizationContractInner;
        }));
    }
}

