/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AuthorizationError;
import com.azure.resourcemanager.apimanagement.models.AuthorizationType;
import com.azure.resourcemanager.apimanagement.models.OAuth2GrantType;
import java.io.IOException;
import java.util.Map;

public final class AuthorizationContractProperties
implements JsonSerializable<AuthorizationContractProperties> {
    private AuthorizationType authorizationType;
    private OAuth2GrantType oAuth2GrantType;
    private Map<String, String> parameters;
    private AuthorizationError error;
    private String status;

    public AuthorizationType authorizationType() {
        return this.authorizationType;
    }

    public AuthorizationContractProperties withAuthorizationType(AuthorizationType authorizationType) {
        this.authorizationType = authorizationType;
        return this;
    }

    public OAuth2GrantType oAuth2GrantType() {
        return this.oAuth2GrantType;
    }

    public AuthorizationContractProperties withOAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
        this.oAuth2GrantType = oAuth2GrantType;
        return this;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public AuthorizationContractProperties withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public AuthorizationError error() {
        return this.error;
    }

    public AuthorizationContractProperties withError(AuthorizationError error) {
        this.error = error;
        return this;
    }

    public String status() {
        return this.status;
    }

    public AuthorizationContractProperties withStatus(String status) {
        this.status = status;
        return this;
    }

    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("authorizationType", this.authorizationType == null ? null : this.authorizationType.toString());
        jsonWriter.writeStringField("oauth2grantType", this.oAuth2GrantType == null ? null : this.oAuth2GrantType.toString());
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeStringField("status", this.status);
        return jsonWriter.writeEndObject();
    }

    public static AuthorizationContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AuthorizationContractProperties)jsonReader.readObject(reader -> {
            AuthorizationContractProperties deserializedAuthorizationContractProperties = new AuthorizationContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("authorizationType".equals(fieldName)) {
                    deserializedAuthorizationContractProperties.authorizationType = AuthorizationType.fromString(reader.getString());
                    continue;
                }
                if ("oauth2grantType".equals(fieldName)) {
                    deserializedAuthorizationContractProperties.oAuth2GrantType = OAuth2GrantType.fromString(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedAuthorizationContractProperties.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedAuthorizationContractProperties.error = AuthorizationError.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAuthorizationContractProperties.status = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthorizationContractProperties;
        });
    }
}

