/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AuthorizationProviderOAuth2Settings;
import java.io.IOException;

public final class AuthorizationProviderContractProperties
implements JsonSerializable<AuthorizationProviderContractProperties> {
    private String displayName;
    private String identityProvider;
    private AuthorizationProviderOAuth2Settings oauth2;

    public String displayName() {
        return this.displayName;
    }

    public AuthorizationProviderContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String identityProvider() {
        return this.identityProvider;
    }

    public AuthorizationProviderContractProperties withIdentityProvider(String identityProvider) {
        this.identityProvider = identityProvider;
        return this;
    }

    public AuthorizationProviderOAuth2Settings oauth2() {
        return this.oauth2;
    }

    public AuthorizationProviderContractProperties withOauth2(AuthorizationProviderOAuth2Settings oauth2) {
        this.oauth2 = oauth2;
        return this;
    }

    public void validate() {
        if (this.oauth2() != null) {
            this.oauth2().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("identityProvider", this.identityProvider);
        jsonWriter.writeJsonField("oauth2", (JsonSerializable)this.oauth2);
        return jsonWriter.writeEndObject();
    }

    public static AuthorizationProviderContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AuthorizationProviderContractProperties)jsonReader.readObject(reader -> {
            AuthorizationProviderContractProperties deserializedAuthorizationProviderContractProperties = new AuthorizationProviderContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedAuthorizationProviderContractProperties.displayName = reader.getString();
                    continue;
                }
                if ("identityProvider".equals(fieldName)) {
                    deserializedAuthorizationProviderContractProperties.identityProvider = reader.getString();
                    continue;
                }
                if ("oauth2".equals(fieldName)) {
                    deserializedAuthorizationProviderContractProperties.oauth2 = AuthorizationProviderOAuth2Settings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthorizationProviderContractProperties;
        });
    }
}

