/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AuthorizationMethod;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServerContractBaseProperties;
import com.azure.resourcemanager.apimanagement.models.BearerTokenSendingMethod;
import com.azure.resourcemanager.apimanagement.models.ClientAuthenticationMethod;
import com.azure.resourcemanager.apimanagement.models.GrantType;
import com.azure.resourcemanager.apimanagement.models.TokenBodyParameterContract;
import java.io.IOException;
import java.util.List;

public final class AuthorizationServerUpdateContractProperties
extends AuthorizationServerContractBaseProperties {
    private String displayName;
    private Boolean useInTestConsole;
    private Boolean useInApiDocumentation;
    private String clientRegistrationEndpoint;
    private String authorizationEndpoint;
    private List<GrantType> grantTypes;
    private String clientId;
    private String clientSecret;

    public String displayName() {
        return this.displayName;
    }

    public AuthorizationServerUpdateContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Boolean useInTestConsole() {
        return this.useInTestConsole;
    }

    public AuthorizationServerUpdateContractProperties withUseInTestConsole(Boolean useInTestConsole) {
        this.useInTestConsole = useInTestConsole;
        return this;
    }

    public Boolean useInApiDocumentation() {
        return this.useInApiDocumentation;
    }

    public AuthorizationServerUpdateContractProperties withUseInApiDocumentation(Boolean useInApiDocumentation) {
        this.useInApiDocumentation = useInApiDocumentation;
        return this;
    }

    public String clientRegistrationEndpoint() {
        return this.clientRegistrationEndpoint;
    }

    public AuthorizationServerUpdateContractProperties withClientRegistrationEndpoint(String clientRegistrationEndpoint) {
        this.clientRegistrationEndpoint = clientRegistrationEndpoint;
        return this;
    }

    public String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public AuthorizationServerUpdateContractProperties withAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    public List<GrantType> grantTypes() {
        return this.grantTypes;
    }

    public AuthorizationServerUpdateContractProperties withGrantTypes(List<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
        return this;
    }

    public String clientId() {
        return this.clientId;
    }

    public AuthorizationServerUpdateContractProperties withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public AuthorizationServerUpdateContractProperties withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Override
    public AuthorizationServerUpdateContractProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AuthorizationServerUpdateContractProperties withAuthorizationMethods(List<AuthorizationMethod> authorizationMethods) {
        super.withAuthorizationMethods(authorizationMethods);
        return this;
    }

    @Override
    public AuthorizationServerUpdateContractProperties withClientAuthenticationMethod(List<ClientAuthenticationMethod> clientAuthenticationMethod) {
        super.withClientAuthenticationMethod(clientAuthenticationMethod);
        return this;
    }

    @Override
    public AuthorizationServerUpdateContractProperties withTokenBodyParameters(List<TokenBodyParameterContract> tokenBodyParameters) {
        super.withTokenBodyParameters(tokenBodyParameters);
        return this;
    }

    @Override
    public AuthorizationServerUpdateContractProperties withTokenEndpoint(String tokenEndpoint) {
        super.withTokenEndpoint(tokenEndpoint);
        return this;
    }

    @Override
    public AuthorizationServerUpdateContractProperties withSupportState(Boolean supportState) {
        super.withSupportState(supportState);
        return this;
    }

    @Override
    public AuthorizationServerUpdateContractProperties withDefaultScope(String defaultScope) {
        super.withDefaultScope(defaultScope);
        return this;
    }

    @Override
    public AuthorizationServerUpdateContractProperties withBearerTokenSendingMethods(List<BearerTokenSendingMethod> bearerTokenSendingMethods) {
        super.withBearerTokenSendingMethods(bearerTokenSendingMethods);
        return this;
    }

    @Override
    public AuthorizationServerUpdateContractProperties withResourceOwnerUsername(String resourceOwnerUsername) {
        super.withResourceOwnerUsername(resourceOwnerUsername);
        return this;
    }

    @Override
    public AuthorizationServerUpdateContractProperties withResourceOwnerPassword(String resourceOwnerPassword) {
        super.withResourceOwnerPassword(resourceOwnerPassword);
        return this;
    }

    @Override
    public void validate() {
        if (this.tokenBodyParameters() != null) {
            this.tokenBodyParameters().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("authorizationMethods", this.authorizationMethods(), (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("clientAuthenticationMethod", this.clientAuthenticationMethod(), (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("tokenBodyParameters", this.tokenBodyParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("tokenEndpoint", this.tokenEndpoint());
        jsonWriter.writeBooleanField("supportState", this.supportState());
        jsonWriter.writeStringField("defaultScope", this.defaultScope());
        jsonWriter.writeArrayField("bearerTokenSendingMethods", this.bearerTokenSendingMethods(), (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("resourceOwnerUsername", this.resourceOwnerUsername());
        jsonWriter.writeStringField("resourceOwnerPassword", this.resourceOwnerPassword());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeBooleanField("useInTestConsole", this.useInTestConsole);
        jsonWriter.writeBooleanField("useInApiDocumentation", this.useInApiDocumentation);
        jsonWriter.writeStringField("clientRegistrationEndpoint", this.clientRegistrationEndpoint);
        jsonWriter.writeStringField("authorizationEndpoint", this.authorizationEndpoint);
        jsonWriter.writeArrayField("grantTypes", this.grantTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeStringField("clientSecret", this.clientSecret);
        return jsonWriter.writeEndObject();
    }

    public static AuthorizationServerUpdateContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AuthorizationServerUpdateContractProperties)jsonReader.readObject(reader -> {
            AuthorizationServerUpdateContractProperties deserializedAuthorizationServerUpdateContractProperties = new AuthorizationServerUpdateContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedAuthorizationServerUpdateContractProperties.withDescription(reader.getString());
                    continue;
                }
                if ("authorizationMethods".equals(fieldName)) {
                    List authorizationMethods = reader.readArray(reader1 -> AuthorizationMethod.fromString(reader1.getString()));
                    deserializedAuthorizationServerUpdateContractProperties.withAuthorizationMethods(authorizationMethods);
                    continue;
                }
                if ("clientAuthenticationMethod".equals(fieldName)) {
                    List clientAuthenticationMethod = reader.readArray(reader1 -> ClientAuthenticationMethod.fromString(reader1.getString()));
                    deserializedAuthorizationServerUpdateContractProperties.withClientAuthenticationMethod(clientAuthenticationMethod);
                    continue;
                }
                if ("tokenBodyParameters".equals(fieldName)) {
                    List tokenBodyParameters = reader.readArray(reader1 -> TokenBodyParameterContract.fromJson(reader1));
                    deserializedAuthorizationServerUpdateContractProperties.withTokenBodyParameters(tokenBodyParameters);
                    continue;
                }
                if ("tokenEndpoint".equals(fieldName)) {
                    deserializedAuthorizationServerUpdateContractProperties.withTokenEndpoint(reader.getString());
                    continue;
                }
                if ("supportState".equals(fieldName)) {
                    deserializedAuthorizationServerUpdateContractProperties.withSupportState((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("defaultScope".equals(fieldName)) {
                    deserializedAuthorizationServerUpdateContractProperties.withDefaultScope(reader.getString());
                    continue;
                }
                if ("bearerTokenSendingMethods".equals(fieldName)) {
                    List bearerTokenSendingMethods = reader.readArray(reader1 -> BearerTokenSendingMethod.fromString(reader1.getString()));
                    deserializedAuthorizationServerUpdateContractProperties.withBearerTokenSendingMethods(bearerTokenSendingMethods);
                    continue;
                }
                if ("resourceOwnerUsername".equals(fieldName)) {
                    deserializedAuthorizationServerUpdateContractProperties.withResourceOwnerUsername(reader.getString());
                    continue;
                }
                if ("resourceOwnerPassword".equals(fieldName)) {
                    deserializedAuthorizationServerUpdateContractProperties.withResourceOwnerPassword(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedAuthorizationServerUpdateContractProperties.displayName = reader.getString();
                    continue;
                }
                if ("useInTestConsole".equals(fieldName)) {
                    deserializedAuthorizationServerUpdateContractProperties.useInTestConsole = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("useInApiDocumentation".equals(fieldName)) {
                    deserializedAuthorizationServerUpdateContractProperties.useInApiDocumentation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("clientRegistrationEndpoint".equals(fieldName)) {
                    deserializedAuthorizationServerUpdateContractProperties.clientRegistrationEndpoint = reader.getString();
                    continue;
                }
                if ("authorizationEndpoint".equals(fieldName)) {
                    deserializedAuthorizationServerUpdateContractProperties.authorizationEndpoint = reader.getString();
                    continue;
                }
                if ("grantTypes".equals(fieldName)) {
                    List grantTypes;
                    deserializedAuthorizationServerUpdateContractProperties.grantTypes = grantTypes = reader.readArray(reader1 -> GrantType.fromString(reader1.getString()));
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedAuthorizationServerUpdateContractProperties.clientId = reader.getString();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedAuthorizationServerUpdateContractProperties.clientSecret = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthorizationServerUpdateContractProperties;
        });
    }
}

