/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CacheContractProperties
implements JsonSerializable<CacheContractProperties> {
    private String description;
    private String connectionString;
    private String useFromLocation;
    private String resourceId;
    private static final ClientLogger LOGGER = new ClientLogger(CacheContractProperties.class);

    public String description() {
        return this.description;
    }

    public CacheContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public CacheContractProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String useFromLocation() {
        return this.useFromLocation;
    }

    public CacheContractProperties withUseFromLocation(String useFromLocation) {
        this.useFromLocation = useFromLocation;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public CacheContractProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public void validate() {
        if (this.connectionString() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionString in model CacheContractProperties"));
        }
        if (this.useFromLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property useFromLocation in model CacheContractProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("useFromLocation", this.useFromLocation);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        return jsonWriter.writeEndObject();
    }

    public static CacheContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CacheContractProperties)jsonReader.readObject(reader -> {
            CacheContractProperties deserializedCacheContractProperties = new CacheContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedCacheContractProperties.connectionString = reader.getString();
                    continue;
                }
                if ("useFromLocation".equals(fieldName)) {
                    deserializedCacheContractProperties.useFromLocation = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCacheContractProperties.description = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedCacheContractProperties.resourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheContractProperties;
        });
    }
}

