/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DeployConfigurationParameterProperties
implements JsonSerializable<DeployConfigurationParameterProperties> {
    private String branch;
    private Boolean force;
    private static final ClientLogger LOGGER = new ClientLogger(DeployConfigurationParameterProperties.class);

    public String branch() {
        return this.branch;
    }

    public DeployConfigurationParameterProperties withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public Boolean force() {
        return this.force;
    }

    public DeployConfigurationParameterProperties withForce(Boolean force) {
        this.force = force;
        return this;
    }

    public void validate() {
        if (this.branch() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property branch in model DeployConfigurationParameterProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeBooleanField("force", this.force);
        return jsonWriter.writeEndObject();
    }

    public static DeployConfigurationParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DeployConfigurationParameterProperties)jsonReader.readObject(reader -> {
            DeployConfigurationParameterProperties deserializedDeployConfigurationParameterProperties = new DeployConfigurationParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("branch".equals(fieldName)) {
                    deserializedDeployConfigurationParameterProperties.branch = reader.getString();
                    continue;
                }
                if ("force".equals(fieldName)) {
                    deserializedDeployConfigurationParameterProperties.force = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeployConfigurationParameterProperties;
        });
    }
}

