/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.EmailTemplateParametersContractProperties;
import java.io.IOException;
import java.util.List;

public final class EmailTemplateContractProperties
implements JsonSerializable<EmailTemplateContractProperties> {
    private String subject;
    private String body;
    private String title;
    private String description;
    private Boolean isDefault;
    private List<EmailTemplateParametersContractProperties> parameters;
    private static final ClientLogger LOGGER = new ClientLogger(EmailTemplateContractProperties.class);

    public String subject() {
        return this.subject;
    }

    public EmailTemplateContractProperties withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String body() {
        return this.body;
    }

    public EmailTemplateContractProperties withBody(String body) {
        this.body = body;
        return this;
    }

    public String title() {
        return this.title;
    }

    public EmailTemplateContractProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    public String description() {
        return this.description;
    }

    public EmailTemplateContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public List<EmailTemplateParametersContractProperties> parameters() {
        return this.parameters;
    }

    public EmailTemplateContractProperties withParameters(List<EmailTemplateParametersContractProperties> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.subject() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subject in model EmailTemplateContractProperties"));
        }
        if (this.body() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property body in model EmailTemplateContractProperties"));
        }
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeStringField("body", this.body);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static EmailTemplateContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EmailTemplateContractProperties)jsonReader.readObject(reader -> {
            EmailTemplateContractProperties deserializedEmailTemplateContractProperties = new EmailTemplateContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subject".equals(fieldName)) {
                    deserializedEmailTemplateContractProperties.subject = reader.getString();
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedEmailTemplateContractProperties.body = reader.getString();
                    continue;
                }
                if ("title".equals(fieldName)) {
                    deserializedEmailTemplateContractProperties.title = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedEmailTemplateContractProperties.description = reader.getString();
                    continue;
                }
                if ("isDefault".equals(fieldName)) {
                    deserializedEmailTemplateContractProperties.isDefault = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedEmailTemplateContractProperties.parameters = parameters = reader.readArray(reader1 -> EmailTemplateParametersContractProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEmailTemplateContractProperties;
        });
    }
}

