/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.EmailTemplateParametersContractProperties;
import java.io.IOException;
import java.util.List;

public final class EmailTemplateUpdateParameterProperties
implements JsonSerializable<EmailTemplateUpdateParameterProperties> {
    private String subject;
    private String title;
    private String description;
    private String body;
    private List<EmailTemplateParametersContractProperties> parameters;

    public String subject() {
        return this.subject;
    }

    public EmailTemplateUpdateParameterProperties withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String title() {
        return this.title;
    }

    public EmailTemplateUpdateParameterProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    public String description() {
        return this.description;
    }

    public EmailTemplateUpdateParameterProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String body() {
        return this.body;
    }

    public EmailTemplateUpdateParameterProperties withBody(String body) {
        this.body = body;
        return this;
    }

    public List<EmailTemplateParametersContractProperties> parameters() {
        return this.parameters;
    }

    public EmailTemplateUpdateParameterProperties withParameters(List<EmailTemplateParametersContractProperties> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("body", this.body);
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static EmailTemplateUpdateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EmailTemplateUpdateParameterProperties)jsonReader.readObject(reader -> {
            EmailTemplateUpdateParameterProperties deserializedEmailTemplateUpdateParameterProperties = new EmailTemplateUpdateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subject".equals(fieldName)) {
                    deserializedEmailTemplateUpdateParameterProperties.subject = reader.getString();
                    continue;
                }
                if ("title".equals(fieldName)) {
                    deserializedEmailTemplateUpdateParameterProperties.title = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedEmailTemplateUpdateParameterProperties.description = reader.getString();
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedEmailTemplateUpdateParameterProperties.body = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedEmailTemplateUpdateParameterProperties.parameters = parameters = reader.readArray(reader1 -> EmailTemplateParametersContractProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEmailTemplateUpdateParameterProperties;
        });
    }
}

