/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.GroupType;
import java.io.IOException;

public final class GroupContractProperties
implements JsonSerializable<GroupContractProperties> {
    private String displayName;
    private String description;
    private Boolean builtIn;
    private GroupType type;
    private String externalId;
    private static final ClientLogger LOGGER = new ClientLogger(GroupContractProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public GroupContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public GroupContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean builtIn() {
        return this.builtIn;
    }

    public GroupType type() {
        return this.type;
    }

    public GroupContractProperties withType(GroupType type) {
        this.type = type;
        return this;
    }

    public String externalId() {
        return this.externalId;
    }

    public GroupContractProperties withExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model GroupContractProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("externalId", this.externalId);
        return jsonWriter.writeEndObject();
    }

    public static GroupContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GroupContractProperties)jsonReader.readObject(reader -> {
            GroupContractProperties deserializedGroupContractProperties = new GroupContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedGroupContractProperties.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGroupContractProperties.description = reader.getString();
                    continue;
                }
                if ("builtIn".equals(fieldName)) {
                    deserializedGroupContractProperties.builtIn = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGroupContractProperties.type = GroupType.fromString(reader.getString());
                    continue;
                }
                if ("externalId".equals(fieldName)) {
                    deserializedGroupContractProperties.externalId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGroupContractProperties;
        });
    }
}

