/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.GroupType;
import java.io.IOException;

public final class GroupCreateParametersProperties
implements JsonSerializable<GroupCreateParametersProperties> {
    private String displayName;
    private String description;
    private GroupType type;
    private String externalId;
    private static final ClientLogger LOGGER = new ClientLogger(GroupCreateParametersProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public GroupCreateParametersProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public GroupCreateParametersProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public GroupType type() {
        return this.type;
    }

    public GroupCreateParametersProperties withType(GroupType type) {
        this.type = type;
        return this;
    }

    public String externalId() {
        return this.externalId;
    }

    public GroupCreateParametersProperties withExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model GroupCreateParametersProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("externalId", this.externalId);
        return jsonWriter.writeEndObject();
    }

    public static GroupCreateParametersProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GroupCreateParametersProperties)jsonReader.readObject(reader -> {
            GroupCreateParametersProperties deserializedGroupCreateParametersProperties = new GroupCreateParametersProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedGroupCreateParametersProperties.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGroupCreateParametersProperties.description = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGroupCreateParametersProperties.type = GroupType.fromString(reader.getString());
                    continue;
                }
                if ("externalId".equals(fieldName)) {
                    deserializedGroupCreateParametersProperties.externalId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGroupCreateParametersProperties;
        });
    }
}

