/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class IssueCommentContractProperties
implements JsonSerializable<IssueCommentContractProperties> {
    private String text;
    private OffsetDateTime createdDate;
    private String userId;
    private static final ClientLogger LOGGER = new ClientLogger(IssueCommentContractProperties.class);

    public String text() {
        return this.text;
    }

    public IssueCommentContractProperties withText(String text) {
        this.text = text;
        return this;
    }

    public OffsetDateTime createdDate() {
        return this.createdDate;
    }

    public IssueCommentContractProperties withCreatedDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public IssueCommentContractProperties withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public void validate() {
        if (this.text() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property text in model IssueCommentContractProperties"));
        }
        if (this.userId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property userId in model IssueCommentContractProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("userId", this.userId);
        jsonWriter.writeStringField("createdDate", this.createdDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDate));
        return jsonWriter.writeEndObject();
    }

    public static IssueCommentContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IssueCommentContractProperties)jsonReader.readObject(reader -> {
            IssueCommentContractProperties deserializedIssueCommentContractProperties = new IssueCommentContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    deserializedIssueCommentContractProperties.text = reader.getString();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedIssueCommentContractProperties.userId = reader.getString();
                    continue;
                }
                if ("createdDate".equals(fieldName)) {
                    deserializedIssueCommentContractProperties.createdDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIssueCommentContractProperties;
        });
    }
}

