/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.IssueContractProperties;
import com.azure.resourcemanager.apimanagement.models.State;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class IssueContractInner
extends ProxyResource {
    private IssueContractProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private IssueContractProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String title() {
        return this.innerProperties() == null ? null : this.innerProperties().title();
    }

    public IssueContractInner withTitle(String title) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueContractProperties();
        }
        this.innerProperties().withTitle(title);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public IssueContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String userId() {
        return this.innerProperties() == null ? null : this.innerProperties().userId();
    }

    public IssueContractInner withUserId(String userId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueContractProperties();
        }
        this.innerProperties().withUserId(userId);
        return this;
    }

    public OffsetDateTime createdDate() {
        return this.innerProperties() == null ? null : this.innerProperties().createdDate();
    }

    public IssueContractInner withCreatedDate(OffsetDateTime createdDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueContractProperties();
        }
        this.innerProperties().withCreatedDate(createdDate);
        return this;
    }

    public State state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public IssueContractInner withState(State state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueContractProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public String apiId() {
        return this.innerProperties() == null ? null : this.innerProperties().apiId();
    }

    public IssueContractInner withApiId(String apiId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IssueContractProperties();
        }
        this.innerProperties().withApiId(apiId);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static IssueContractInner fromJson(JsonReader jsonReader) throws IOException {
        return (IssueContractInner)((Object)jsonReader.readObject(reader -> {
            IssueContractInner deserializedIssueContractInner = new IssueContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedIssueContractInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIssueContractInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIssueContractInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIssueContractInner.innerProperties = IssueContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIssueContractInner;
        }));
    }
}

