/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.IssueContractBaseProperties;
import com.azure.resourcemanager.apimanagement.models.State;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class IssueContractProperties
extends IssueContractBaseProperties {
    private String title;
    private String description;
    private String userId;
    private static final ClientLogger LOGGER = new ClientLogger(IssueContractProperties.class);

    public String title() {
        return this.title;
    }

    public IssueContractProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    public String description() {
        return this.description;
    }

    public IssueContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public IssueContractProperties withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    @Override
    public IssueContractProperties withCreatedDate(OffsetDateTime createdDate) {
        super.withCreatedDate(createdDate);
        return this;
    }

    @Override
    public IssueContractProperties withState(State state) {
        super.withState(state);
        return this;
    }

    @Override
    public IssueContractProperties withApiId(String apiId) {
        super.withApiId(apiId);
        return this;
    }

    @Override
    public void validate() {
        if (this.title() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property title in model IssueContractProperties"));
        }
        if (this.description() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property description in model IssueContractProperties"));
        }
        if (this.userId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property userId in model IssueContractProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdDate", this.createdDate() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDate()));
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("apiId", this.apiId());
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("userId", this.userId);
        return jsonWriter.writeEndObject();
    }

    public static IssueContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IssueContractProperties)jsonReader.readObject(reader -> {
            IssueContractProperties deserializedIssueContractProperties = new IssueContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdDate".equals(fieldName)) {
                    deserializedIssueContractProperties.withCreatedDate((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedIssueContractProperties.withState(State.fromString(reader.getString()));
                    continue;
                }
                if ("apiId".equals(fieldName)) {
                    deserializedIssueContractProperties.withApiId(reader.getString());
                    continue;
                }
                if ("title".equals(fieldName)) {
                    deserializedIssueContractProperties.title = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedIssueContractProperties.description = reader.getString();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedIssueContractProperties.userId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIssueContractProperties;
        });
    }
}

