/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.IssueContractBaseProperties;
import com.azure.resourcemanager.apimanagement.models.State;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class IssueUpdateContractProperties
extends IssueContractBaseProperties {
    private String title;
    private String description;
    private String userId;

    public String title() {
        return this.title;
    }

    public IssueUpdateContractProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    public String description() {
        return this.description;
    }

    public IssueUpdateContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public IssueUpdateContractProperties withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    @Override
    public IssueUpdateContractProperties withCreatedDate(OffsetDateTime createdDate) {
        super.withCreatedDate(createdDate);
        return this;
    }

    @Override
    public IssueUpdateContractProperties withState(State state) {
        super.withState(state);
        return this;
    }

    @Override
    public IssueUpdateContractProperties withApiId(String apiId) {
        super.withApiId(apiId);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdDate", this.createdDate() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDate()));
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("apiId", this.apiId());
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("userId", this.userId);
        return jsonWriter.writeEndObject();
    }

    public static IssueUpdateContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IssueUpdateContractProperties)jsonReader.readObject(reader -> {
            IssueUpdateContractProperties deserializedIssueUpdateContractProperties = new IssueUpdateContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdDate".equals(fieldName)) {
                    deserializedIssueUpdateContractProperties.withCreatedDate((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedIssueUpdateContractProperties.withState(State.fromString(reader.getString()));
                    continue;
                }
                if ("apiId".equals(fieldName)) {
                    deserializedIssueUpdateContractProperties.withApiId(reader.getString());
                    continue;
                }
                if ("title".equals(fieldName)) {
                    deserializedIssueUpdateContractProperties.title = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedIssueUpdateContractProperties.description = reader.getString();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedIssueUpdateContractProperties.userId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIssueUpdateContractProperties;
        });
    }
}

