/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.LoggerType;
import java.io.IOException;
import java.util.Map;

public final class LoggerUpdateParameters
implements JsonSerializable<LoggerUpdateParameters> {
    private LoggerType loggerType;
    private String description;
    private Map<String, String> credentials;
    private Boolean isBuffered;

    public LoggerType loggerType() {
        return this.loggerType;
    }

    public LoggerUpdateParameters withLoggerType(LoggerType loggerType) {
        this.loggerType = loggerType;
        return this;
    }

    public String description() {
        return this.description;
    }

    public LoggerUpdateParameters withDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, String> credentials() {
        return this.credentials;
    }

    public LoggerUpdateParameters withCredentials(Map<String, String> credentials) {
        this.credentials = credentials;
        return this;
    }

    public Boolean isBuffered() {
        return this.isBuffered;
    }

    public LoggerUpdateParameters withIsBuffered(Boolean isBuffered) {
        this.isBuffered = isBuffered;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("loggerType", this.loggerType == null ? null : this.loggerType.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("credentials", this.credentials, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isBuffered", this.isBuffered);
        return jsonWriter.writeEndObject();
    }

    public static LoggerUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (LoggerUpdateParameters)jsonReader.readObject(reader -> {
            LoggerUpdateParameters deserializedLoggerUpdateParameters = new LoggerUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loggerType".equals(fieldName)) {
                    deserializedLoggerUpdateParameters.loggerType = LoggerType.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedLoggerUpdateParameters.description = reader.getString();
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    Map credentials;
                    deserializedLoggerUpdateParameters.credentials = credentials = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("isBuffered".equals(fieldName)) {
                    deserializedLoggerUpdateParameters.isBuffered = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoggerUpdateParameters;
        });
    }
}

