/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OpenidConnectProviderContractProperties
implements JsonSerializable<OpenidConnectProviderContractProperties> {
    private String displayName;
    private String description;
    private String metadataEndpoint;
    private String clientId;
    private String clientSecret;
    private Boolean useInTestConsole;
    private Boolean useInApiDocumentation;
    private static final ClientLogger LOGGER = new ClientLogger(OpenidConnectProviderContractProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public OpenidConnectProviderContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public OpenidConnectProviderContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String metadataEndpoint() {
        return this.metadataEndpoint;
    }

    public OpenidConnectProviderContractProperties withMetadataEndpoint(String metadataEndpoint) {
        this.metadataEndpoint = metadataEndpoint;
        return this;
    }

    public String clientId() {
        return this.clientId;
    }

    public OpenidConnectProviderContractProperties withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public OpenidConnectProviderContractProperties withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Boolean useInTestConsole() {
        return this.useInTestConsole;
    }

    public OpenidConnectProviderContractProperties withUseInTestConsole(Boolean useInTestConsole) {
        this.useInTestConsole = useInTestConsole;
        return this;
    }

    public Boolean useInApiDocumentation() {
        return this.useInApiDocumentation;
    }

    public OpenidConnectProviderContractProperties withUseInApiDocumentation(Boolean useInApiDocumentation) {
        this.useInApiDocumentation = useInApiDocumentation;
        return this;
    }

    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model OpenidConnectProviderContractProperties"));
        }
        if (this.metadataEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property metadataEndpoint in model OpenidConnectProviderContractProperties"));
        }
        if (this.clientId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clientId in model OpenidConnectProviderContractProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("metadataEndpoint", this.metadataEndpoint);
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("clientSecret", this.clientSecret);
        jsonWriter.writeBooleanField("useInTestConsole", this.useInTestConsole);
        jsonWriter.writeBooleanField("useInApiDocumentation", this.useInApiDocumentation);
        return jsonWriter.writeEndObject();
    }

    public static OpenidConnectProviderContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OpenidConnectProviderContractProperties)jsonReader.readObject(reader -> {
            OpenidConnectProviderContractProperties deserializedOpenidConnectProviderContractProperties = new OpenidConnectProviderContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.displayName = reader.getString();
                    continue;
                }
                if ("metadataEndpoint".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.metadataEndpoint = reader.getString();
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.clientId = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.description = reader.getString();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.clientSecret = reader.getString();
                    continue;
                }
                if ("useInTestConsole".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.useInTestConsole = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("useInApiDocumentation".equals(fieldName)) {
                    deserializedOpenidConnectProviderContractProperties.useInApiDocumentation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenidConnectProviderContractProperties;
        });
    }
}

