/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.OperationEntityBaseContract;
import com.azure.resourcemanager.apimanagement.models.ParameterContract;
import com.azure.resourcemanager.apimanagement.models.RequestContract;
import com.azure.resourcemanager.apimanagement.models.ResponseContract;
import java.io.IOException;
import java.util.List;

public final class OperationUpdateContractProperties
extends OperationEntityBaseContract {
    private String displayName;
    private String method;
    private String urlTemplate;

    public String displayName() {
        return this.displayName;
    }

    public OperationUpdateContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String method() {
        return this.method;
    }

    public OperationUpdateContractProperties withMethod(String method) {
        this.method = method;
        return this;
    }

    public String urlTemplate() {
        return this.urlTemplate;
    }

    public OperationUpdateContractProperties withUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
        return this;
    }

    @Override
    public OperationUpdateContractProperties withTemplateParameters(List<ParameterContract> templateParameters) {
        super.withTemplateParameters(templateParameters);
        return this;
    }

    @Override
    public OperationUpdateContractProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public OperationUpdateContractProperties withRequest(RequestContract request) {
        super.withRequest(request);
        return this;
    }

    @Override
    public OperationUpdateContractProperties withResponses(List<ResponseContract> responses) {
        super.withResponses(responses);
        return this;
    }

    @Override
    public OperationUpdateContractProperties withPolicies(String policies) {
        super.withPolicies(policies);
        return this;
    }

    @Override
    public void validate() {
        if (this.templateParameters() != null) {
            this.templateParameters().forEach(e -> e.validate());
        }
        if (this.request() != null) {
            this.request().validate();
        }
        if (this.responses() != null) {
            this.responses().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("templateParameters", this.templateParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeJsonField("request", (JsonSerializable)this.request());
        jsonWriter.writeArrayField("responses", this.responses(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("policies", this.policies());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("method", this.method);
        jsonWriter.writeStringField("urlTemplate", this.urlTemplate);
        return jsonWriter.writeEndObject();
    }

    public static OperationUpdateContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OperationUpdateContractProperties)jsonReader.readObject(reader -> {
            OperationUpdateContractProperties deserializedOperationUpdateContractProperties = new OperationUpdateContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("templateParameters".equals(fieldName)) {
                    List templateParameters = reader.readArray(reader1 -> ParameterContract.fromJson(reader1));
                    deserializedOperationUpdateContractProperties.withTemplateParameters(templateParameters);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedOperationUpdateContractProperties.withDescription(reader.getString());
                    continue;
                }
                if ("request".equals(fieldName)) {
                    deserializedOperationUpdateContractProperties.withRequest(RequestContract.fromJson(reader));
                    continue;
                }
                if ("responses".equals(fieldName)) {
                    List responses = reader.readArray(reader1 -> ResponseContract.fromJson(reader1));
                    deserializedOperationUpdateContractProperties.withResponses(responses);
                    continue;
                }
                if ("policies".equals(fieldName)) {
                    deserializedOperationUpdateContractProperties.withPolicies(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedOperationUpdateContractProperties.displayName = reader.getString();
                    continue;
                }
                if ("method".equals(fieldName)) {
                    deserializedOperationUpdateContractProperties.method = reader.getString();
                    continue;
                }
                if ("urlTemplate".equals(fieldName)) {
                    deserializedOperationUpdateContractProperties.urlTemplate = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationUpdateContractProperties;
        });
    }
}

