/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.PolicyContentFormat;
import java.io.IOException;

public final class PolicyContractProperties
implements JsonSerializable<PolicyContractProperties> {
    private String value;
    private PolicyContentFormat format;
    private static final ClientLogger LOGGER = new ClientLogger(PolicyContractProperties.class);

    public String value() {
        return this.value;
    }

    public PolicyContractProperties withValue(String value) {
        this.value = value;
        return this;
    }

    public PolicyContentFormat format() {
        return this.format;
    }

    public PolicyContractProperties withFormat(PolicyContentFormat format) {
        this.format = format;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model PolicyContractProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        return jsonWriter.writeEndObject();
    }

    public static PolicyContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyContractProperties)jsonReader.readObject(reader -> {
            PolicyContractProperties deserializedPolicyContractProperties = new PolicyContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedPolicyContractProperties.value = reader.getString();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedPolicyContractProperties.format = PolicyContentFormat.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyContractProperties;
        });
    }
}

