/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.PolicyFragmentContentFormat;
import java.io.IOException;

public final class PolicyFragmentContractProperties
implements JsonSerializable<PolicyFragmentContractProperties> {
    private String value;
    private String description;
    private PolicyFragmentContentFormat format;
    private String provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(PolicyFragmentContractProperties.class);

    public String value() {
        return this.value;
    }

    public PolicyFragmentContractProperties withValue(String value) {
        this.value = value;
        return this;
    }

    public String description() {
        return this.description;
    }

    public PolicyFragmentContractProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public PolicyFragmentContentFormat format() {
        return this.format;
    }

    public PolicyFragmentContractProperties withFormat(PolicyFragmentContentFormat format) {
        this.format = format;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model PolicyFragmentContractProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        return jsonWriter.writeEndObject();
    }

    public static PolicyFragmentContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyFragmentContractProperties)jsonReader.readObject(reader -> {
            PolicyFragmentContractProperties deserializedPolicyFragmentContractProperties = new PolicyFragmentContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedPolicyFragmentContractProperties.value = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPolicyFragmentContractProperties.description = reader.getString();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedPolicyFragmentContractProperties.format = PolicyFragmentContentFormat.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPolicyFragmentContractProperties.provisioningState = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyFragmentContractProperties;
        });
    }
}

