/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.PortalConfigCorsProperties;
import com.azure.resourcemanager.apimanagement.models.PortalConfigCspProperties;
import com.azure.resourcemanager.apimanagement.models.PortalConfigDelegationProperties;
import com.azure.resourcemanager.apimanagement.models.PortalConfigPropertiesSignin;
import com.azure.resourcemanager.apimanagement.models.PortalConfigPropertiesSignup;
import java.io.IOException;

public final class PortalConfigProperties
implements JsonSerializable<PortalConfigProperties> {
    private Boolean enableBasicAuth;
    private PortalConfigPropertiesSignin signin;
    private PortalConfigPropertiesSignup signup;
    private PortalConfigDelegationProperties delegation;
    private PortalConfigCorsProperties cors;
    private PortalConfigCspProperties csp;

    public Boolean enableBasicAuth() {
        return this.enableBasicAuth;
    }

    public PortalConfigProperties withEnableBasicAuth(Boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
        return this;
    }

    public PortalConfigPropertiesSignin signin() {
        return this.signin;
    }

    public PortalConfigProperties withSignin(PortalConfigPropertiesSignin signin) {
        this.signin = signin;
        return this;
    }

    public PortalConfigPropertiesSignup signup() {
        return this.signup;
    }

    public PortalConfigProperties withSignup(PortalConfigPropertiesSignup signup) {
        this.signup = signup;
        return this;
    }

    public PortalConfigDelegationProperties delegation() {
        return this.delegation;
    }

    public PortalConfigProperties withDelegation(PortalConfigDelegationProperties delegation) {
        this.delegation = delegation;
        return this;
    }

    public PortalConfigCorsProperties cors() {
        return this.cors;
    }

    public PortalConfigProperties withCors(PortalConfigCorsProperties cors) {
        this.cors = cors;
        return this;
    }

    public PortalConfigCspProperties csp() {
        return this.csp;
    }

    public PortalConfigProperties withCsp(PortalConfigCspProperties csp) {
        this.csp = csp;
        return this;
    }

    public void validate() {
        if (this.signin() != null) {
            this.signin().validate();
        }
        if (this.signup() != null) {
            this.signup().validate();
        }
        if (this.delegation() != null) {
            this.delegation().validate();
        }
        if (this.cors() != null) {
            this.cors().validate();
        }
        if (this.csp() != null) {
            this.csp().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enableBasicAuth", this.enableBasicAuth);
        jsonWriter.writeJsonField("signin", (JsonSerializable)this.signin);
        jsonWriter.writeJsonField("signup", (JsonSerializable)this.signup);
        jsonWriter.writeJsonField("delegation", (JsonSerializable)this.delegation);
        jsonWriter.writeJsonField("cors", (JsonSerializable)this.cors);
        jsonWriter.writeJsonField("csp", (JsonSerializable)this.csp);
        return jsonWriter.writeEndObject();
    }

    public static PortalConfigProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PortalConfigProperties)jsonReader.readObject(reader -> {
            PortalConfigProperties deserializedPortalConfigProperties = new PortalConfigProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enableBasicAuth".equals(fieldName)) {
                    deserializedPortalConfigProperties.enableBasicAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("signin".equals(fieldName)) {
                    deserializedPortalConfigProperties.signin = PortalConfigPropertiesSignin.fromJson(reader);
                    continue;
                }
                if ("signup".equals(fieldName)) {
                    deserializedPortalConfigProperties.signup = PortalConfigPropertiesSignup.fromJson(reader);
                    continue;
                }
                if ("delegation".equals(fieldName)) {
                    deserializedPortalConfigProperties.delegation = PortalConfigDelegationProperties.fromJson(reader);
                    continue;
                }
                if ("cors".equals(fieldName)) {
                    deserializedPortalConfigProperties.cors = PortalConfigCorsProperties.fromJson(reader);
                    continue;
                }
                if ("csp".equals(fieldName)) {
                    deserializedPortalConfigProperties.csp = PortalConfigCspProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPortalConfigProperties;
        });
    }
}

