/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ArmIdWrapper;
import com.azure.resourcemanager.apimanagement.models.PrivateLinkServiceConnectionState;
import java.io.IOException;
import java.util.List;

public final class PrivateEndpointConnectionWrapperProperties
implements JsonSerializable<PrivateEndpointConnectionWrapperProperties> {
    private ArmIdWrapper privateEndpoint;
    private PrivateLinkServiceConnectionState privateLinkServiceConnectionState;
    private String provisioningState;
    private List<String> groupIds;
    private static final ClientLogger LOGGER = new ClientLogger(PrivateEndpointConnectionWrapperProperties.class);

    public ArmIdWrapper privateEndpoint() {
        return this.privateEndpoint;
    }

    public PrivateEndpointConnectionWrapperProperties withPrivateEndpoint(ArmIdWrapper privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public PrivateEndpointConnectionWrapperProperties withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property privateLinkServiceConnectionState in model PrivateEndpointConnectionWrapperProperties"));
        }
        this.privateLinkServiceConnectionState().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateLinkServiceConnectionState", (JsonSerializable)this.privateLinkServiceConnectionState);
        jsonWriter.writeJsonField("privateEndpoint", (JsonSerializable)this.privateEndpoint);
        return jsonWriter.writeEndObject();
    }

    public static PrivateEndpointConnectionWrapperProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateEndpointConnectionWrapperProperties)jsonReader.readObject(reader -> {
            PrivateEndpointConnectionWrapperProperties deserializedPrivateEndpointConnectionWrapperProperties = new PrivateEndpointConnectionWrapperProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateLinkServiceConnectionState".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionWrapperProperties.privateLinkServiceConnectionState = PrivateLinkServiceConnectionState.fromJson(reader);
                    continue;
                }
                if ("privateEndpoint".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionWrapperProperties.privateEndpoint = ArmIdWrapper.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionWrapperProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("groupIds".equals(fieldName)) {
                    List groupIds;
                    deserializedPrivateEndpointConnectionWrapperProperties.groupIds = groupIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateEndpointConnectionWrapperProperties;
        });
    }
}

