/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductContractProperties;
import com.azure.resourcemanager.apimanagement.models.ProductState;
import java.io.IOException;

public final class ProductContractInner
extends ProxyResource {
    private ProductContractProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ProductContractProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public ProductContractInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductContractProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ProductContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String terms() {
        return this.innerProperties() == null ? null : this.innerProperties().terms();
    }

    public ProductContractInner withTerms(String terms) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductContractProperties();
        }
        this.innerProperties().withTerms(terms);
        return this;
    }

    public Boolean subscriptionRequired() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptionRequired();
    }

    public ProductContractInner withSubscriptionRequired(Boolean subscriptionRequired) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductContractProperties();
        }
        this.innerProperties().withSubscriptionRequired(subscriptionRequired);
        return this;
    }

    public Boolean approvalRequired() {
        return this.innerProperties() == null ? null : this.innerProperties().approvalRequired();
    }

    public ProductContractInner withApprovalRequired(Boolean approvalRequired) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductContractProperties();
        }
        this.innerProperties().withApprovalRequired(approvalRequired);
        return this;
    }

    public Integer subscriptionsLimit() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptionsLimit();
    }

    public ProductContractInner withSubscriptionsLimit(Integer subscriptionsLimit) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductContractProperties();
        }
        this.innerProperties().withSubscriptionsLimit(subscriptionsLimit);
        return this;
    }

    public ProductState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public ProductContractInner withState(ProductState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductContractProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ProductContractInner fromJson(JsonReader jsonReader) throws IOException {
        return (ProductContractInner)((Object)jsonReader.readObject(reader -> {
            ProductContractInner deserializedProductContractInner = new ProductContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedProductContractInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedProductContractInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedProductContractInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedProductContractInner.innerProperties = ProductContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProductContractInner;
        }));
    }
}

