/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ProductEntityBaseParameters;
import com.azure.resourcemanager.apimanagement.models.ProductState;
import java.io.IOException;

public final class ProductContractProperties
extends ProductEntityBaseParameters {
    private String displayName;
    private static final ClientLogger LOGGER = new ClientLogger(ProductContractProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public ProductContractProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public ProductContractProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ProductContractProperties withTerms(String terms) {
        super.withTerms(terms);
        return this;
    }

    @Override
    public ProductContractProperties withSubscriptionRequired(Boolean subscriptionRequired) {
        super.withSubscriptionRequired(subscriptionRequired);
        return this;
    }

    @Override
    public ProductContractProperties withApprovalRequired(Boolean approvalRequired) {
        super.withApprovalRequired(approvalRequired);
        return this;
    }

    @Override
    public ProductContractProperties withSubscriptionsLimit(Integer subscriptionsLimit) {
        super.withSubscriptionsLimit(subscriptionsLimit);
        return this;
    }

    @Override
    public ProductContractProperties withState(ProductState state) {
        super.withState(state);
        return this;
    }

    @Override
    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model ProductContractProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("terms", this.terms());
        jsonWriter.writeBooleanField("subscriptionRequired", this.subscriptionRequired());
        jsonWriter.writeBooleanField("approvalRequired", this.approvalRequired());
        jsonWriter.writeNumberField("subscriptionsLimit", (Number)this.subscriptionsLimit());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("displayName", this.displayName);
        return jsonWriter.writeEndObject();
    }

    public static ProductContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ProductContractProperties)jsonReader.readObject(reader -> {
            ProductContractProperties deserializedProductContractProperties = new ProductContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedProductContractProperties.withDescription(reader.getString());
                    continue;
                }
                if ("terms".equals(fieldName)) {
                    deserializedProductContractProperties.withTerms(reader.getString());
                    continue;
                }
                if ("subscriptionRequired".equals(fieldName)) {
                    deserializedProductContractProperties.withSubscriptionRequired((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("approvalRequired".equals(fieldName)) {
                    deserializedProductContractProperties.withApprovalRequired((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("subscriptionsLimit".equals(fieldName)) {
                    deserializedProductContractProperties.withSubscriptionsLimit((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedProductContractProperties.withState(ProductState.fromString(reader.getString()));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedProductContractProperties.displayName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProductContractProperties;
        });
    }
}

