/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.QuotaCounterValueContractProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class QuotaCounterContractInner
implements JsonSerializable<QuotaCounterContractInner> {
    private String counterKey;
    private String periodKey;
    private OffsetDateTime periodStartTime;
    private OffsetDateTime periodEndTime;
    private QuotaCounterValueContractProperties value;
    private static final ClientLogger LOGGER = new ClientLogger(QuotaCounterContractInner.class);

    public String counterKey() {
        return this.counterKey;
    }

    public QuotaCounterContractInner withCounterKey(String counterKey) {
        this.counterKey = counterKey;
        return this;
    }

    public String periodKey() {
        return this.periodKey;
    }

    public QuotaCounterContractInner withPeriodKey(String periodKey) {
        this.periodKey = periodKey;
        return this;
    }

    public OffsetDateTime periodStartTime() {
        return this.periodStartTime;
    }

    public QuotaCounterContractInner withPeriodStartTime(OffsetDateTime periodStartTime) {
        this.periodStartTime = periodStartTime;
        return this;
    }

    public OffsetDateTime periodEndTime() {
        return this.periodEndTime;
    }

    public QuotaCounterContractInner withPeriodEndTime(OffsetDateTime periodEndTime) {
        this.periodEndTime = periodEndTime;
        return this;
    }

    public QuotaCounterValueContractProperties value() {
        return this.value;
    }

    public QuotaCounterContractInner withValue(QuotaCounterValueContractProperties value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.counterKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property counterKey in model QuotaCounterContractInner"));
        }
        if (this.periodKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property periodKey in model QuotaCounterContractInner"));
        }
        if (this.periodStartTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property periodStartTime in model QuotaCounterContractInner"));
        }
        if (this.periodEndTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property periodEndTime in model QuotaCounterContractInner"));
        }
        if (this.value() != null) {
            this.value().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("counterKey", this.counterKey);
        jsonWriter.writeStringField("periodKey", this.periodKey);
        jsonWriter.writeStringField("periodStartTime", this.periodStartTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.periodStartTime));
        jsonWriter.writeStringField("periodEndTime", this.periodEndTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.periodEndTime));
        jsonWriter.writeJsonField("value", (JsonSerializable)this.value);
        return jsonWriter.writeEndObject();
    }

    public static QuotaCounterContractInner fromJson(JsonReader jsonReader) throws IOException {
        return (QuotaCounterContractInner)jsonReader.readObject(reader -> {
            QuotaCounterContractInner deserializedQuotaCounterContractInner = new QuotaCounterContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("counterKey".equals(fieldName)) {
                    deserializedQuotaCounterContractInner.counterKey = reader.getString();
                    continue;
                }
                if ("periodKey".equals(fieldName)) {
                    deserializedQuotaCounterContractInner.periodKey = reader.getString();
                    continue;
                }
                if ("periodStartTime".equals(fieldName)) {
                    deserializedQuotaCounterContractInner.periodStartTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("periodEndTime".equals(fieldName)) {
                    deserializedQuotaCounterContractInner.periodEndTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedQuotaCounterContractInner.value = QuotaCounterValueContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQuotaCounterContractInner;
        });
    }
}

