/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.SubscriptionState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SubscriptionUpdateParameterProperties
implements JsonSerializable<SubscriptionUpdateParameterProperties> {
    private String ownerId;
    private String scope;
    private OffsetDateTime expirationDate;
    private String displayName;
    private String primaryKey;
    private String secondaryKey;
    private SubscriptionState state;
    private String stateComment;
    private Boolean allowTracing;

    public String ownerId() {
        return this.ownerId;
    }

    public SubscriptionUpdateParameterProperties withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public SubscriptionUpdateParameterProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    public SubscriptionUpdateParameterProperties withExpirationDate(OffsetDateTime expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public SubscriptionUpdateParameterProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String primaryKey() {
        return this.primaryKey;
    }

    public SubscriptionUpdateParameterProperties withPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public String secondaryKey() {
        return this.secondaryKey;
    }

    public SubscriptionUpdateParameterProperties withSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
        return this;
    }

    public SubscriptionState state() {
        return this.state;
    }

    public SubscriptionUpdateParameterProperties withState(SubscriptionState state) {
        this.state = state;
        return this;
    }

    public String stateComment() {
        return this.stateComment;
    }

    public SubscriptionUpdateParameterProperties withStateComment(String stateComment) {
        this.stateComment = stateComment;
        return this;
    }

    public Boolean allowTracing() {
        return this.allowTracing;
    }

    public SubscriptionUpdateParameterProperties withAllowTracing(Boolean allowTracing) {
        this.allowTracing = allowTracing;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ownerId", this.ownerId);
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("expirationDate", this.expirationDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDate));
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("primaryKey", this.primaryKey);
        jsonWriter.writeStringField("secondaryKey", this.secondaryKey);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("stateComment", this.stateComment);
        jsonWriter.writeBooleanField("allowTracing", this.allowTracing);
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionUpdateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionUpdateParameterProperties)jsonReader.readObject(reader -> {
            SubscriptionUpdateParameterProperties deserializedSubscriptionUpdateParameterProperties = new SubscriptionUpdateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ownerId".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.ownerId = reader.getString();
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.scope = reader.getString();
                    continue;
                }
                if ("expirationDate".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.expirationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.displayName = reader.getString();
                    continue;
                }
                if ("primaryKey".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.primaryKey = reader.getString();
                    continue;
                }
                if ("secondaryKey".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.secondaryKey = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.state = SubscriptionState.fromString(reader.getString());
                    continue;
                }
                if ("stateComment".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.stateComment = reader.getString();
                    continue;
                }
                if ("allowTracing".equals(fieldName)) {
                    deserializedSubscriptionUpdateParameterProperties.allowTracing = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionUpdateParameterProperties;
        });
    }
}

