/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiTagResourceContractProperties;
import com.azure.resourcemanager.apimanagement.models.OperationTagResourceContractProperties;
import com.azure.resourcemanager.apimanagement.models.ProductTagResourceContractProperties;
import com.azure.resourcemanager.apimanagement.models.TagResourceContractProperties;
import java.io.IOException;

public final class TagResourceContractInner
implements JsonSerializable<TagResourceContractInner> {
    private TagResourceContractProperties tag;
    private ApiTagResourceContractProperties api;
    private OperationTagResourceContractProperties operation;
    private ProductTagResourceContractProperties product;
    private static final ClientLogger LOGGER = new ClientLogger(TagResourceContractInner.class);

    public TagResourceContractProperties tag() {
        return this.tag;
    }

    public TagResourceContractInner withTag(TagResourceContractProperties tag) {
        this.tag = tag;
        return this;
    }

    public ApiTagResourceContractProperties api() {
        return this.api;
    }

    public TagResourceContractInner withApi(ApiTagResourceContractProperties api) {
        this.api = api;
        return this;
    }

    public OperationTagResourceContractProperties operation() {
        return this.operation;
    }

    public TagResourceContractInner withOperation(OperationTagResourceContractProperties operation) {
        this.operation = operation;
        return this;
    }

    public ProductTagResourceContractProperties product() {
        return this.product;
    }

    public TagResourceContractInner withProduct(ProductTagResourceContractProperties product) {
        this.product = product;
        return this;
    }

    public void validate() {
        if (this.tag() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tag in model TagResourceContractInner"));
        }
        this.tag().validate();
        if (this.api() != null) {
            this.api().validate();
        }
        if (this.operation() != null) {
            this.operation().validate();
        }
        if (this.product() != null) {
            this.product().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("tag", (JsonSerializable)this.tag);
        jsonWriter.writeJsonField("api", (JsonSerializable)this.api);
        jsonWriter.writeJsonField("operation", (JsonSerializable)this.operation);
        jsonWriter.writeJsonField("product", (JsonSerializable)this.product);
        return jsonWriter.writeEndObject();
    }

    public static TagResourceContractInner fromJson(JsonReader jsonReader) throws IOException {
        return (TagResourceContractInner)jsonReader.readObject(reader -> {
            TagResourceContractInner deserializedTagResourceContractInner = new TagResourceContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tag".equals(fieldName)) {
                    deserializedTagResourceContractInner.tag = TagResourceContractProperties.fromJson(reader);
                    continue;
                }
                if ("api".equals(fieldName)) {
                    deserializedTagResourceContractInner.api = ApiTagResourceContractProperties.fromJson(reader);
                    continue;
                }
                if ("operation".equals(fieldName)) {
                    deserializedTagResourceContractInner.operation = OperationTagResourceContractProperties.fromJson(reader);
                    continue;
                }
                if ("product".equals(fieldName)) {
                    deserializedTagResourceContractInner.product = ProductTagResourceContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTagResourceContractInner;
        });
    }
}

