/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class TenantConfigurationSyncStateContractProperties
implements JsonSerializable<TenantConfigurationSyncStateContractProperties> {
    private String branch;
    private String commitId;
    private Boolean isExport;
    private Boolean isSynced;
    private Boolean isGitEnabled;
    private OffsetDateTime syncDate;
    private OffsetDateTime configurationChangeDate;
    private String lastOperationId;

    public String branch() {
        return this.branch;
    }

    public TenantConfigurationSyncStateContractProperties withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public String commitId() {
        return this.commitId;
    }

    public TenantConfigurationSyncStateContractProperties withCommitId(String commitId) {
        this.commitId = commitId;
        return this;
    }

    public Boolean isExport() {
        return this.isExport;
    }

    public TenantConfigurationSyncStateContractProperties withIsExport(Boolean isExport) {
        this.isExport = isExport;
        return this;
    }

    public Boolean isSynced() {
        return this.isSynced;
    }

    public TenantConfigurationSyncStateContractProperties withIsSynced(Boolean isSynced) {
        this.isSynced = isSynced;
        return this;
    }

    public Boolean isGitEnabled() {
        return this.isGitEnabled;
    }

    public TenantConfigurationSyncStateContractProperties withIsGitEnabled(Boolean isGitEnabled) {
        this.isGitEnabled = isGitEnabled;
        return this;
    }

    public OffsetDateTime syncDate() {
        return this.syncDate;
    }

    public TenantConfigurationSyncStateContractProperties withSyncDate(OffsetDateTime syncDate) {
        this.syncDate = syncDate;
        return this;
    }

    public OffsetDateTime configurationChangeDate() {
        return this.configurationChangeDate;
    }

    public TenantConfigurationSyncStateContractProperties withConfigurationChangeDate(OffsetDateTime configurationChangeDate) {
        this.configurationChangeDate = configurationChangeDate;
        return this;
    }

    public String lastOperationId() {
        return this.lastOperationId;
    }

    public TenantConfigurationSyncStateContractProperties withLastOperationId(String lastOperationId) {
        this.lastOperationId = lastOperationId;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeStringField("commitId", this.commitId);
        jsonWriter.writeBooleanField("isExport", this.isExport);
        jsonWriter.writeBooleanField("isSynced", this.isSynced);
        jsonWriter.writeBooleanField("isGitEnabled", this.isGitEnabled);
        jsonWriter.writeStringField("syncDate", this.syncDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.syncDate));
        jsonWriter.writeStringField("configurationChangeDate", this.configurationChangeDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.configurationChangeDate));
        jsonWriter.writeStringField("lastOperationId", this.lastOperationId);
        return jsonWriter.writeEndObject();
    }

    public static TenantConfigurationSyncStateContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TenantConfigurationSyncStateContractProperties)jsonReader.readObject(reader -> {
            TenantConfigurationSyncStateContractProperties deserializedTenantConfigurationSyncStateContractProperties = new TenantConfigurationSyncStateContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("branch".equals(fieldName)) {
                    deserializedTenantConfigurationSyncStateContractProperties.branch = reader.getString();
                    continue;
                }
                if ("commitId".equals(fieldName)) {
                    deserializedTenantConfigurationSyncStateContractProperties.commitId = reader.getString();
                    continue;
                }
                if ("isExport".equals(fieldName)) {
                    deserializedTenantConfigurationSyncStateContractProperties.isExport = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isSynced".equals(fieldName)) {
                    deserializedTenantConfigurationSyncStateContractProperties.isSynced = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isGitEnabled".equals(fieldName)) {
                    deserializedTenantConfigurationSyncStateContractProperties.isGitEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("syncDate".equals(fieldName)) {
                    deserializedTenantConfigurationSyncStateContractProperties.syncDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("configurationChangeDate".equals(fieldName)) {
                    deserializedTenantConfigurationSyncStateContractProperties.configurationChangeDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastOperationId".equals(fieldName)) {
                    deserializedTenantConfigurationSyncStateContractProperties.lastOperationId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTenantConfigurationSyncStateContractProperties;
        });
    }
}

