/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.GroupContractProperties;
import com.azure.resourcemanager.apimanagement.fluent.models.UserContractProperties;
import com.azure.resourcemanager.apimanagement.fluent.models.UserIdentityContractInner;
import com.azure.resourcemanager.apimanagement.models.UserState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class UserContractInner
extends ProxyResource {
    private UserContractProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private UserContractProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String firstName() {
        return this.innerProperties() == null ? null : this.innerProperties().firstName();
    }

    public UserContractInner withFirstName(String firstName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withFirstName(firstName);
        return this;
    }

    public String lastName() {
        return this.innerProperties() == null ? null : this.innerProperties().lastName();
    }

    public UserContractInner withLastName(String lastName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withLastName(lastName);
        return this;
    }

    public String email() {
        return this.innerProperties() == null ? null : this.innerProperties().email();
    }

    public UserContractInner withEmail(String email) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withEmail(email);
        return this;
    }

    public OffsetDateTime registrationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().registrationDate();
    }

    public UserContractInner withRegistrationDate(OffsetDateTime registrationDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withRegistrationDate(registrationDate);
        return this;
    }

    public List<GroupContractProperties> groups() {
        return this.innerProperties() == null ? null : this.innerProperties().groups();
    }

    public UserState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public UserContractInner withState(UserState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public String note() {
        return this.innerProperties() == null ? null : this.innerProperties().note();
    }

    public UserContractInner withNote(String note) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withNote(note);
        return this;
    }

    public List<UserIdentityContractInner> identities() {
        return this.innerProperties() == null ? null : this.innerProperties().identities();
    }

    public UserContractInner withIdentities(List<UserIdentityContractInner> identities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserContractProperties();
        }
        this.innerProperties().withIdentities((List)identities);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static UserContractInner fromJson(JsonReader jsonReader) throws IOException {
        return (UserContractInner)((Object)jsonReader.readObject(reader -> {
            UserContractInner deserializedUserContractInner = new UserContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedUserContractInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedUserContractInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedUserContractInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedUserContractInner.innerProperties = UserContractProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserContractInner;
        }));
    }
}

