/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.GroupContractProperties;
import com.azure.resourcemanager.apimanagement.fluent.models.UserIdentityContractInner;
import com.azure.resourcemanager.apimanagement.models.UserEntityBaseParameters;
import com.azure.resourcemanager.apimanagement.models.UserState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class UserContractProperties
extends UserEntityBaseParameters {
    private String firstName;
    private String lastName;
    private String email;
    private OffsetDateTime registrationDate;
    private List<GroupContractProperties> groups;

    public String firstName() {
        return this.firstName;
    }

    public UserContractProperties withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String lastName() {
        return this.lastName;
    }

    public UserContractProperties withLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String email() {
        return this.email;
    }

    public UserContractProperties withEmail(String email) {
        this.email = email;
        return this;
    }

    public OffsetDateTime registrationDate() {
        return this.registrationDate;
    }

    public UserContractProperties withRegistrationDate(OffsetDateTime registrationDate) {
        this.registrationDate = registrationDate;
        return this;
    }

    public List<GroupContractProperties> groups() {
        return this.groups;
    }

    @Override
    public UserContractProperties withState(UserState state) {
        super.withState(state);
        return this;
    }

    @Override
    public UserContractProperties withNote(String note) {
        super.withNote(note);
        return this;
    }

    @Override
    public UserContractProperties withIdentities(List<UserIdentityContractInner> identities) {
        super.withIdentities(identities);
        return this;
    }

    @Override
    public void validate() {
        if (this.groups() != null) {
            this.groups().forEach(e -> e.validate());
        }
        if (this.identities() != null) {
            this.identities().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("note", this.note());
        jsonWriter.writeArrayField("identities", this.identities(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("firstName", this.firstName);
        jsonWriter.writeStringField("lastName", this.lastName);
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeStringField("registrationDate", this.registrationDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.registrationDate));
        return jsonWriter.writeEndObject();
    }

    public static UserContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return (UserContractProperties)jsonReader.readObject(reader -> {
            UserContractProperties deserializedUserContractProperties = new UserContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedUserContractProperties.withState(UserState.fromString(reader.getString()));
                    continue;
                }
                if ("note".equals(fieldName)) {
                    deserializedUserContractProperties.withNote(reader.getString());
                    continue;
                }
                if ("identities".equals(fieldName)) {
                    List identities = reader.readArray(reader1 -> UserIdentityContractInner.fromJson(reader1));
                    deserializedUserContractProperties.withIdentities(identities);
                    continue;
                }
                if ("firstName".equals(fieldName)) {
                    deserializedUserContractProperties.firstName = reader.getString();
                    continue;
                }
                if ("lastName".equals(fieldName)) {
                    deserializedUserContractProperties.lastName = reader.getString();
                    continue;
                }
                if ("email".equals(fieldName)) {
                    deserializedUserContractProperties.email = reader.getString();
                    continue;
                }
                if ("registrationDate".equals(fieldName)) {
                    deserializedUserContractProperties.registrationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("groups".equals(fieldName)) {
                    List groups;
                    deserializedUserContractProperties.groups = groups = reader.readArray(reader1 -> GroupContractProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserContractProperties;
        });
    }
}

